/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.recipeTypes.type;

import com.devdyna.synergy.init.recipeTypes.input.MonoItemInput;
import com.devdyna.synergy.init.types.zRecipeTypes;
import com.devdyna.synergy.utils.x;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DryableBricksRecipe
implements Recipe<MonoItemInput> {
    private final ItemStack input;
    private final BlockState block;
    private final ItemStack output;

    public DryableBricksRecipe(ItemStack input, BlockState block, ItemStack output) {
        this.input = input;
        this.block = block;
        this.output = output;
    }

    public boolean matches(MonoItemInput r, Level l) {
        return r.input().is(this.input.getItem());
    }

    public ItemStack assemble(MonoItemInput i, HolderLookup.Provider r) {
        return this.output;
    }

    public boolean canCraftInDimensions(int xz, int y) {
        return false;
    }

    public RecipeType<?> getType() {
        return zRecipeTypes.DRYABLE_BRICKS.getType();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)Items.BRICK);
    }

    public RecipeSerializer<?> getSerializer() {
        return zRecipeTypes.DRYABLE_BRICKS.getSerializer();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.copyOf(List.of(x.ingredient(this.input)));
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.output;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public BlockState getBlock() {
        return this.block;
    }
}

