/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.recipeTypes.builders;

import com.devdyna.synergy.init.recipeTypes.type.UrnRitualRecipe;
import com.devdyna.synergy.utils.x;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public class UrnRitualBuilder
implements RecipeBuilder {
    private List<Ingredient> input = new ArrayList<Ingredient>();
    private ItemStack output;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private UrnRitualBuilder() {
    }

    public static UrnRitualBuilder of() {
        return new UrnRitualBuilder();
    }

    public UrnRitualBuilder add(Ingredient input) {
        this.input.add(input);
        return this;
    }

    public UrnRitualBuilder add(Item input) {
        return this.add(x.ingredient(input));
    }

    public UrnRitualBuilder add(DeferredHolder<Item, Item> input) {
        return this.add((Item)input.get());
    }

    public UrnRitualBuilder add(TagKey<Item> input) {
        return this.add(x.ingredient(input));
    }

    public UrnRitualBuilder add(ItemLike input) {
        return this.add(x.ingredient(input));
    }

    public UrnRitualBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public UrnRitualBuilder output(Item output) {
        return this.output(x.item((ItemLike)output));
    }

    public UrnRitualBuilder output(ItemLike output) {
        return this.output(x.item(output));
    }

    public UrnRitualBuilder output(DeferredHolder<Item, Item> output) {
        return this.output((Item)output.get());
    }

    public UrnRitualBuilder output(Item output, int count) {
        return this.output(x.item(output, count));
    }

    public UrnRitualBuilder output(DeferredHolder<Item, Item> output, int count) {
        return this.output((Item)output.get(), count);
    }

    public UrnRitualBuilder unlockedBy() {
        return this.unlockedBy("synergy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])((ItemLike[])this.input.stream().flatMap(i -> Arrays.stream(i.getItems()).map(ItemStack::getItem)).toArray(Item[]::new))));
    }

    public UrnRitualBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public UrnRitualBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return this.output.getItem();
    }

    public void save(RecipeOutput recipeOutput, String extra) {
        this.save(recipeOutput, x.rl("urn_ritual/" + x.path(this.output.getItem()) + extra));
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, "");
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("Missing/Null Criteria " + String.valueOf(pId));
        }
        Advancement.Builder advancement = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        UrnRitualRecipe shapelessrecipe = new UrnRitualRecipe(this.input, this.output);
        pRecipeOutput.accept(pId, (Recipe)shapelessrecipe, advancement.build(pId.withPrefix("recipes/" + RecipeCategory.MISC.getFolderName() + "/")));
    }
}

