/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.recipeTypes.builders;

import com.devdyna.synergy.init.recipeTypes.type.FuelCellRecipe;
import com.devdyna.synergy.utils.x;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ReactorCellBuilder
implements RecipeBuilder {
    private Ingredient input;
    private ItemStack output;
    private int duration;
    private double heat;
    private int fe;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private ReactorCellBuilder() {
    }

    public static ReactorCellBuilder of() {
        return new ReactorCellBuilder();
    }

    public ReactorCellBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public ReactorCellBuilder input(Item input) {
        return this.input(x.ingredient(input));
    }

    public ReactorCellBuilder input(DeferredHolder<Item, Item> input) {
        return this.input((Item)input.get());
    }

    public ReactorCellBuilder input(TagKey<Item> input) {
        return this.input(x.ingredient(input));
    }

    public ReactorCellBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public ReactorCellBuilder output(Item output) {
        return this.output(x.item((ItemLike)output));
    }

    public ReactorCellBuilder output(DeferredHolder<Item, Item> output) {
        return this.output((Item)output.get());
    }

    public ReactorCellBuilder output(Item output, int count) {
        return this.output(x.item(output, count));
    }

    public ReactorCellBuilder output(DeferredHolder<Item, Item> output, int count) {
        return this.output((Item)output.get(), count);
    }

    public ReactorCellBuilder energy(int fe) {
        this.fe = fe;
        return this;
    }

    public ReactorCellBuilder duration(int ticks) {
        this.duration = ticks;
        return this;
    }

    public ReactorCellBuilder heat(double heat) {
        this.heat = heat;
        return this;
    }

    public ReactorCellBuilder unlockedBy() {
        return this.unlockedBy("synergy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{this.input.getItems()[0].getItem()}));
    }

    public ReactorCellBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public ReactorCellBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return this.output.getItem();
    }

    public void save(RecipeOutput recipeOutput, String extra) {
        this.save(recipeOutput, x.rl("reactor_reaction/" + x.path(this.output.getItem()) + extra));
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, "");
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("Missing/Null Criteria " + String.valueOf(pId));
        }
        Advancement.Builder advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        FuelCellRecipe shapelessrecipe = new FuelCellRecipe(this.input, this.output, this.duration, this.fe, this.heat);
        pRecipeOutput.accept(pId, (Recipe)shapelessrecipe, advancement$builder.build(pId.withPrefix("recipes/" + RecipeCategory.MISC.getFolderName() + "/")));
    }
}

