/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.recipeTypes.builders;

import com.devdyna.synergy.init.recipeTypes.type.QuernMillingRecipe;
import com.devdyna.synergy.utils.x;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public class QuernMillingBuilder
implements RecipeBuilder {
    private Ingredient input;
    private int tick = 60;
    private ItemStack output;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private QuernMillingBuilder() {
    }

    public static QuernMillingBuilder of() {
        return new QuernMillingBuilder();
    }

    public QuernMillingBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public QuernMillingBuilder input(Item input) {
        return this.input(x.ingredient(input));
    }

    public QuernMillingBuilder input(DeferredHolder<Item, Item> input) {
        return this.input((Item)input.get());
    }

    public QuernMillingBuilder input(TagKey<Item> input) {
        return this.input(x.ingredient(input));
    }

    public QuernMillingBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public QuernMillingBuilder delay(int tick) {
        this.tick = tick;
        return this;
    }

    public QuernMillingBuilder output(Item output) {
        return this.output(x.item((ItemLike)output));
    }

    public QuernMillingBuilder output(DeferredHolder<Item, Item> output) {
        return this.output((Item)output.get());
    }

    public QuernMillingBuilder output(Item output, int count) {
        return this.output(x.item(output, count));
    }

    public QuernMillingBuilder output(DeferredHolder<Item, Item> output, int count) {
        return this.output((Item)output.get(), count);
    }

    public QuernMillingBuilder unlockedBy() {
        return this.unlockedBy("synergy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])((ItemLike[])Arrays.stream(this.input.getItems()).map(ItemStack::getItem).toArray(Item[]::new))));
    }

    public QuernMillingBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public QuernMillingBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return this.output.getItem();
    }

    public void save(RecipeOutput recipeOutput, String extra) {
        this.save(recipeOutput, x.rl("quern/" + x.path(this.output.getItem()) + extra));
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, "");
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("Missing/Null Criteria " + String.valueOf(pId));
        }
        Advancement.Builder advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        QuernMillingRecipe shapelessrecipe = new QuernMillingRecipe(this.input, this.output, this.tick);
        pRecipeOutput.accept(pId, (Recipe)shapelessrecipe, advancement$builder.build(pId.withPrefix("recipes/" + RecipeCategory.MISC.getFolderName() + "/")));
    }
}

