/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.recipeTypes.builders;

import com.devdyna.synergy.init.recipeTypes.type.ItemUseRecipe;
import com.devdyna.synergy.utils.x;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ItemUseBuilder
implements RecipeBuilder {
    private Ingredient inputItem;
    private BlockState inputState;
    private BlockState outputState;
    private boolean canBeDisabled = false;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public static ItemUseBuilder of() {
        return new ItemUseBuilder();
    }

    public ItemUseBuilder inputItem(ItemStack i) {
        this.inputItem = x.ingredient(i);
        return this;
    }

    public ItemUseBuilder inputItem(Item input) {
        return this.inputItem(x.item((ItemLike)input));
    }

    public ItemUseBuilder inputItem(DeferredHolder<Item, Item> input) {
        return this.inputItem((Item)input.get());
    }

    public ItemUseBuilder inputBlock(BlockState b) {
        this.inputState = b;
        return this;
    }

    public ItemUseBuilder canBeDisabled() {
        this.canBeDisabled = true;
        return this;
    }

    public ItemUseBuilder outputBlock(BlockState b) {
        this.outputState = b;
        return this;
    }

    public ItemUseBuilder inputBlock(Block b) {
        return this.inputBlock(b.defaultBlockState());
    }

    public ItemUseBuilder outputBlock(Block b) {
        return this.outputBlock(b.defaultBlockState());
    }

    public ItemUseBuilder inputBlock(DeferredHolder<Block, ?> b) {
        return this.inputBlock((Block)b.get());
    }

    public ItemUseBuilder outputBlock(DeferredHolder<Block, ?> b) {
        return this.outputBlock((Block)b.get());
    }

    public ItemUseBuilder unlockedBy() {
        return this.unlockedBy("synergy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])((ItemLike[])Arrays.stream(this.inputItem.getItems()).map(ItemStack::getItem).toArray(Item[]::new))));
    }

    public ItemUseBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public ItemUseBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return x.item(this.outputState).getItem();
    }

    public void save(RecipeOutput recipeOutput, String extra) {
        this.save(recipeOutput, x.rl("item_use/" + x.path(this.outputState.getBlock()) + "_from_" + x.path(this.inputState.getBlock()) + extra));
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, "");
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("Missing/Null Criteria " + String.valueOf(pId));
        }
        Advancement.Builder advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        ItemUseRecipe shapelessrecipe = new ItemUseRecipe(this.inputItem, this.inputState, this.outputState, this.canBeDisabled);
        pRecipeOutput.accept(pId, (Recipe)shapelessrecipe, advancement$builder.build(pId.withPrefix("recipes/" + RecipeCategory.MISC.getFolderName() + "/")));
    }
}

