/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.recipeTypes.builders;

import com.devdyna.synergy.init.recipeTypes.type.FluidProviderRecipe;
import com.devdyna.synergy.utils.x;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidProviderBuilder
implements RecipeBuilder {
    private BlockState core;
    private BlockState below = Blocks.AIR.defaultBlockState();
    private BlockState left = Blocks.AIR.defaultBlockState();
    private BlockState right = Blocks.AIR.defaultBlockState();
    private FluidStack output;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public static FluidProviderBuilder of() {
        return new FluidProviderBuilder();
    }

    public FluidProviderBuilder core(BlockState b) {
        this.core = b;
        return this;
    }

    public FluidProviderBuilder below(@Nullable BlockState b) {
        this.below = b;
        return this;
    }

    public FluidProviderBuilder left(@Nullable BlockState b) {
        this.left = b;
        return this;
    }

    public FluidProviderBuilder right(@Nullable BlockState b) {
        this.right = b;
        return this;
    }

    public FluidProviderBuilder core(Block b) {
        return this.core(b.defaultBlockState());
    }

    public FluidProviderBuilder below(@Nullable Block b) {
        return this.below(b.defaultBlockState());
    }

    public FluidProviderBuilder left(@Nullable Block b) {
        return this.left(b.defaultBlockState());
    }

    public FluidProviderBuilder right(@Nullable Block b) {
        return this.right(b.defaultBlockState());
    }

    public FluidProviderBuilder output(FluidStack b) {
        this.output = b;
        return this;
    }

    public FluidProviderBuilder output(Fluid b) {
        return this.output(x.fluid(b));
    }

    public FluidProviderBuilder output(Fluid b, int c) {
        return this.output(x.fluid(b, c));
    }

    public FluidProviderBuilder unlockedBy() {
        return this.unlockedBy("synergy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{x.item(this.core).getItem()}));
    }

    public FluidProviderBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public FluidProviderBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return x.item(this.core).getItem();
    }

    public void save(RecipeOutput recipeOutput, String extra) {
        this.save(recipeOutput, x.rl("provider/fluid/" + x.path(this.output.getFluid()) + "_from_" + x.path(this.core) + extra));
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, "");
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("Missing/Null Criteria " + String.valueOf(pId));
        }
        Advancement.Builder advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        FluidProviderRecipe shapelessrecipe = new FluidProviderRecipe(this.core, this.below, this.left, this.right, this.output);
        pRecipeOutput.accept(pId, shapelessrecipe, advancement$builder.build(pId.withPrefix("recipes/" + RecipeCategory.MISC.getFolderName() + "/")));
    }
}

