/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.recipeTypes.builders;

import com.devdyna.synergy.init.recipeTypes.type.DryableBricksRecipe;
import com.devdyna.synergy.utils.x;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;

public class DryableBricksBuilder
implements RecipeBuilder {
    private ItemStack input;
    private BlockState block;
    private ItemStack output;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public static DryableBricksBuilder of() {
        return new DryableBricksBuilder();
    }

    public DryableBricksBuilder input(ItemStack input) {
        this.input = input;
        return this;
    }

    public DryableBricksBuilder block(BlockState block) {
        this.block = block;
        return this;
    }

    public DryableBricksBuilder block(Block block) {
        return this.block(block.defaultBlockState());
    }

    public DryableBricksBuilder input(Item input) {
        return this.input(x.item((ItemLike)input));
    }

    public DryableBricksBuilder input(DeferredHolder<Item, Item> input) {
        return this.input((Item)input.get());
    }

    public DryableBricksBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public DryableBricksBuilder output(DeferredHolder<Item, Item> output) {
        return this.output((Item)output.get());
    }

    public DryableBricksBuilder output(Item output) {
        return this.output(x.item((ItemLike)output));
    }

    public DryableBricksBuilder unlockedBy() {
        return this.unlockedBy("synergy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{this.input.getItem()}));
    }

    public DryableBricksBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public DryableBricksBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return this.output.getItem();
    }

    public void save(RecipeOutput recipeOutput, String extra) {
        this.save(recipeOutput, x.rl("dryable_bricks/" + x.path(this.output) + extra));
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, "");
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("Missing/Null Criteria " + String.valueOf(pId));
        }
        Advancement.Builder advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        DryableBricksRecipe shapelessrecipe = new DryableBricksRecipe(this.input, this.block, this.output);
        pRecipeOutput.accept(pId, (Recipe)shapelessrecipe, advancement$builder.build(pId.withPrefix("recipes/" + RecipeCategory.MISC.getFolderName() + "/")));
    }
}

