/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.recipeTypes.builders;

import com.devdyna.synergy.init.recipeTypes.type.CropResultRecipe;
import com.devdyna.synergy.utils.x;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CropResultBuilder
implements RecipeBuilder {
    private Ingredient input;
    private List<ItemStack> output;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public static CropResultBuilder of() {
        return new CropResultBuilder();
    }

    public CropResultBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public CropResultBuilder input(Item input) {
        return this.input(x.ingredient(input));
    }

    public CropResultBuilder input(TagKey<Item> input) {
        return this.input(x.ingredient(input));
    }

    public CropResultBuilder input(ItemLike input) {
        return this.input(x.ingredient(input));
    }

    public CropResultBuilder input(DeferredHolder<Item, Item> input) {
        return this.input((Item)input.get());
    }

    public CropResultBuilder output(List<ItemStack> output) {
        this.output = output;
        return this;
    }

    public CropResultBuilder unlockedBy() {
        return this.unlockedBy("synergy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{this.input.getItems()[0].getItem()}));
    }

    public CropResultBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public CropResultBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return this.output.get(0).getItem();
    }

    public void save(RecipeOutput recipeOutput, String extra) {
        this.save(recipeOutput, x.rl("jei/crop_result/" + x.path(this.output.getFirst()) + extra));
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, "");
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("Missing/Null Criteria " + String.valueOf(pId));
        }
        Advancement.Builder advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        CropResultRecipe shapelessrecipe = new CropResultRecipe(this.input, this.output);
        pRecipeOutput.accept(pId, (Recipe)shapelessrecipe, advancement$builder.build(pId.withPrefix("recipes/" + RecipeCategory.MISC.getFolderName() + "/")));
    }
}

