/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.urn;

import com.devdyna.synergy.api.beLogic.ItemStorageBlock;
import com.devdyna.synergy.api.beLogic.NoGuiStorage;
import com.devdyna.synergy.api.coreBE.be.TickingBE;
import com.devdyna.synergy.init.recipeTypes.input.ItemListInput;
import com.devdyna.synergy.init.recipeTypes.type.UrnRitualRecipe;
import com.devdyna.synergy.init.types.zBlockEntities;
import com.devdyna.synergy.init.types.zHandlers;
import com.devdyna.synergy.init.types.zRecipeTypes;
import com.devdyna.synergy.utils.LevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class UrnBE
extends TickingBE
implements ItemStorageBlock,
NoGuiStorage {
    private BlockCapabilityCache<IItemHandler, Direction> cache;

    public UrnBE(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public UrnBE(BlockPos pos, BlockState blockState) {
        this((BlockEntityType)zBlockEntities.URN.get(), pos, blockState);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.getStorage().getSlots());
        for (int i = 0; i < this.getStorage().getSlots(); ++i) {
            inv.setItem(i, this.getStorage().getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    @Override
    public ItemStackHandler getStorage() {
        return (ItemStackHandler)this.getData(zHandlers.ITEM_STORAGE);
    }

    @Override
    public int MachineSlots() {
        return 9;
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.getBlockPos(), null);
        }
    }

    @Override
    public ItemStack insertItem(ItemStack stack) {
        ItemStack remaining = stack;
        for (int i = 0; i < this.getStorage().getSlots() && !(remaining = this.getStorage().insertItem(i, remaining, false)).isEmpty(); ++i) {
        }
        return remaining;
    }

    @Override
    public ItemStack extractItem() {
        for (int i = 0; i < this.getStorage().getSlots(); ++i) {
            ItemStack extracted = this.getStorage().extractItem(i, this.getStorage().getStackInSlot(i).getCount(), false);
            if (extracted.isEmpty()) continue;
            return extracted;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void tickClient() {
        BlockPos pos = this.getBlockPos();
        if (LevelUtil.chance(25, this.level)) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.65, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void tickServer() {
        Optional recipe;
        if (!this.getInventory().isEmpty() && LevelUtil.chance(75, this.level) && this.level.getGameTime() % 20L == 0L && this.level != null && !(recipe = this.level.getRecipeManager().getRecipeFor(zRecipeTypes.URN_RITUAL_RECIPE.getType(), (RecipeInput)new ItemListInput(this.getInventory()), this.level)).isEmpty()) {
            NonNullList<Ingredient> input = ((UrnRitualRecipe)((RecipeHolder)recipe.get()).value()).getIngredients();
            ItemStack output = ((UrnRitualRecipe)((RecipeHolder)recipe.get()).value()).getResultItem();
            LevelUtil.popItemFromPos(this.level, this.getBlockPos(), output.copy());
            this.extractItems(input);
            if (LevelUtil.chance(25, this.level)) {
                this.level.playSound(null, this.getBlockPos(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 0.5f * (LevelUtil.chance(50, this.level) ? 1.0f : 0.75f), 1.0f);
            }
            UrnBE.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
        }
    }

    private void extractItems(NonNullList<Ingredient> input) {
        for (int i = 0; i < input.size(); ++i) {
            for (int j = 0; j < this.getStorage().getSlots(); ++j) {
                ItemStack storedItem = this.getStorage().getStackInSlot(j);
                if (!((Ingredient)input.get(i)).test(storedItem)) continue;
                this.getStorage().extractItem(j, 1, false);
            }
        }
    }

    private List<ItemStack> getInventory() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        IItemHandler cap = (IItemHandler)this.cache.getCapability();
        if (cap != null) {
            for (int i = 0; i < cap.getSlots(); ++i) {
                if (cap.getStackInSlot(i).isEmpty()) continue;
                items.add(cap.getStackInSlot(i));
            }
        }
        return items;
    }
}

