/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.tools;

import com.devdyna.synergy.init.builder.reactor.controller.ReactorControllerBE;
import com.devdyna.synergy.zStatic;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SolderingGun
extends Item {
    public SolderingGun() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext c) {
        Level level = c.getLevel();
        BlockPos pos = c.getClickedPos();
        Player player = c.getPlayer();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReactorControllerBE) {
            ReactorControllerBE be = (ReactorControllerBE)blockEntity;
            if (c.getHand().equals((Object)InteractionHand.MAIN_HAND)) {
                int radius;
                CompoundTag nbt = be.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
                int newrange = radius = nbt.getInt("aoe");
                if (!player.isCrouching()) {
                    if (be.getRange().test(radius + 1)) {
                        ++newrange;
                    }
                } else if (be.getRange().test(radius - 1)) {
                    --newrange;
                }
                if (newrange == radius) {
                    return InteractionResult.FAIL;
                }
                nbt.putInt("aoe", newrange);
                be.loadWithComponents(nbt, (HolderLookup.Provider)level.registryAccess());
                be.setChanged();
                be.updateAOE();
                player.playSound(SoundEvents.ITEM_FRAME_ROTATE_ITEM);
                return InteractionResult.SUCCESS_NO_ITEM_USED;
            }
        }
        return super.useOn(c);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)("synergy." + zStatic.Items.soldering_gun)));
    }
}

