/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.tools;

import com.devdyna.synergy.utils.LevelUtil;
import com.devdyna.synergy.zStatic;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;

public class PlantMixture
extends BoneMealItem {
    public PlantMixture() {
        super(new Item.Properties());
    }

    public InteractionResult useOn(UseOnContext c) {
        Level level = c.getLevel();
        BlockPos pos = c.getClickedPos();
        BlockState state = level.getBlockState(pos);
        RandomSource random = level.random;
        ItemStack item = c.getItemInHand();
        Block block = state.getBlock();
        int x2 = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if ((block instanceof NetherWartBlock || (block instanceof SugarCaneBlock || block instanceof CactusBlock) && level.getBlockState(pos.above()).isAir() && !level.getBlockState(pos.below().below()).is(block) || block instanceof VineBlock || block instanceof StemBlock && (Integer)state.getValue((Property)StemBlock.AGE) == 7) && state.isRandomlyTicking()) {
            item.shrink(1);
            if (!level.isClientSide) {
                LevelUtil.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (ServerLevel)level, pos, true, LevelUtil.getRandomValue(7, level) + 5);
                for (int i = 0; i < 10; ++i) {
                    if (!state.isRandomlyTicking()) continue;
                    state.randomTick((ServerLevel)level, pos, random);
                }
            }
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            return InteractionResult.SUCCESS;
        }
        if (block instanceof FlowerBlock) {
            if (!level.isClientSide) {
                LevelUtil.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (ServerLevel)level, pos, true, LevelUtil.getRandomValue(7, level) + 3);
                BlockPos.randomBetweenClosed((RandomSource)random, (int)LevelUtil.getRandomValue(12, level), (int)(x2 - 3), (int)y, (int)(z - 3), (int)(x2 + 3), (int)(y + 1), (int)(z + 3)).forEach(ps -> {
                    if ((level.getBlockState(ps.below()).is(BlockTags.DIRT) || level.getBlockState(ps.below()).getBlock() instanceof FarmBlock) && level.getBlockState(ps).canBeReplaced()) {
                        level.setBlockAndUpdate(ps, state);
                    }
                });
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(c);
    }

    public void appendHoverText(ItemStack i, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        t.add((Component)Component.translatable((String)("synergy." + zStatic.tips.MIXTURE_TIP)));
    }
}

