/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.tools;

import com.devdyna.synergy.api.node.nodeType;
import com.devdyna.synergy.api.pipe.pipeType;
import com.devdyna.synergy.init.types.zBlockTag;
import com.devdyna.synergy.zStatic;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PipeRefactorizer
extends Item {
    public PipeRefactorizer() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext c) {
        Level level = c.getLevel();
        BlockPos pos = c.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = c.getPlayer();
        if (state.is(zBlockTag.CAN_CONNECT)) {
            player.playSound(SoundEvents.CHERRY_WOOD_BUTTON_CLICK_ON);
            player.swing(player.getUsedItemHand());
            if (state.is(zBlockTag.PIPE)) {
                state = pipeType.updatePipeOnPlace(state, level, pos);
            }
            if (state.is(zBlockTag.NODE)) {
                state = nodeType.updateNodeOnPlace(state, level, pos, ((Direction)state.getValue((Property)nodeType.FACING)).getOpposite());
            }
            level.setBlockAndUpdate(pos, state);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(c);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)("synergy." + zStatic.Items.refactorizer)));
    }
}

