/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.tools;

import com.devdyna.synergy.api.beLogic.AreaOfEffect;
import com.devdyna.synergy.init.types.zComponents;
import com.devdyna.synergy.zStatic;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class Configurator
extends Item {
    public Configurator() {
        super(new Item.Properties().stacksTo(1).component(zComponents.GLOBAL_POS, null));
    }

    public InteractionResult useOn(UseOnContext c) {
        Level level = c.getLevel();
        BlockPos pos = c.getClickedPos();
        BlockState block = level.getBlockState(c.getClickedPos());
        ItemStack item = c.getItemInHand();
        Player player = c.getPlayer();
        InteractionHand hand = c.getHand();
        BlockEntity be = level.getBlockEntity(pos);
        if (hand == InteractionHand.MAIN_HAND && be != null && be instanceof AreaOfEffect) {
            if (level.isClientSide) {
                player.playSound(SoundEvents.AMETHYST_BLOCK_RESONATE);
            } else {
                item.set(zComponents.GLOBAL_POS, (Object)new GlobalPos(level.dimension(), pos));
                player.swing(hand);
                player.displayClientMessage((Component)Component.translatable((String)("synergy." + zStatic.Items.configurator + ".link")).append((Component)Component.literal((String)block.getBlock().getName().getString())), true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(c);
    }

    public void appendHoverText(ItemStack i, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        GlobalPos nbt = (GlobalPos)i.get(zComponents.GLOBAL_POS);
        t.add((Component)Component.translatable((String)("synergy." + zStatic.Items.configurator + ".tip")));
        if (nbt != null) {
            BlockPos pos = nbt.pos();
            ResourceKey dim = nbt.dimension();
            t.add((Component)Component.translatable((String)("synergy." + zStatic.Items.configurator + ".dim")).append((Component)Component.literal((String)dim.registry().toString()).withStyle(ChatFormatting.GREEN)));
            t.add((Component)Component.translatable((String)("synergy." + zStatic.Items.configurator + ".blockpos")).append((Component)Component.literal((String)("" + pos.getX())).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)(" " + pos.getY())).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)(" " + pos.getZ())).withStyle(ChatFormatting.AQUA)));
        }
    }
}

