/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.tools;

import com.devdyna.synergy.api.beLogic.EnergyBlock;
import com.devdyna.synergy.init.types.zComponents;
import com.devdyna.synergy.init.types.zHandlers;
import com.devdyna.synergy.utils.StringUtil;
import com.devdyna.synergy.zStatic;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.energy.EnergyStorage;

public class Battery
extends Item {
    private int capacity;

    public Battery(int capacity) {
        super(new Item.Properties().stacksTo(1).component(zComponents.FE_STORED, null));
        this.capacity = capacity;
    }

    public InteractionResult useOn(UseOnContext c) {
        BlockEntity be = c.getLevel().getBlockEntity(c.getClickedPos());
        if (be != null) {
            EnergyStorage data;
            if (c.getItemInHand().get(zComponents.FE_STORED) == null || (Integer)c.getItemInHand().get(zComponents.FE_STORED) == 0) {
                if (((EnergyBlock)be).canExtract()) {
                    EnergyStorage data2 = (EnergyStorage)be.getData(zHandlers.ENERGY_STORAGE);
                    c.getItemInHand().set(zComponents.FE_STORED, (Object)data2.extractEnergy(Math.min(this.capacity, data2.getEnergyStored()), false));
                    c.getPlayer().swing(c.getHand());
                    c.getLevel().playSound(c.getPlayer(), c.getClickedPos(), SoundEvents.WOODEN_BUTTON_CLICK_OFF, SoundSource.PLAYERS, 1.0f, 2.0f);
                }
            } else if (((EnergyBlock)be).canReceive() && (data = (EnergyStorage)be.getData(zHandlers.ENERGY_STORAGE)).getMaxEnergyStored() - data.getEnergyStored() != 0) {
                int item = (Integer)c.getItemInHand().get(zComponents.FE_STORED);
                int extraction = Math.min(data.receiveEnergy(item, true), item);
                data.receiveEnergy(extraction, false);
                c.getItemInHand().set(zComponents.FE_STORED, (Object)(item - extraction));
                c.getPlayer().swing(c.getHand());
                c.getLevel().playSound(c.getPlayer(), c.getClickedPos(), SoundEvents.WOODEN_BUTTON_CLICK_ON, SoundSource.PLAYERS, 1.0f, 2.0f);
            }
        }
        return super.useOn(c);
    }

    public void appendHoverText(ItemStack i, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        t.add((Component)Component.translatable((String)("synergy." + zStatic.Items.Batteries.TYPE_BATTERY + ".tip")));
        t.add((Component)Component.translatable((String)("synergy." + zStatic.Items.Batteries.TYPE_BATTERY + ".energy")).append((Component)Component.literal((String)((String)(i.get(zComponents.FE_STORED) == null ? "0" : String.valueOf(Screen.hasShiftDown() ? Integer.valueOf((Integer)i.get(zComponents.FE_STORED)) : StringUtil.getFormat().format(((Integer)i.get(zComponents.FE_STORED)).intValue()))) + "/" + String.valueOf(Screen.hasShiftDown() ? Integer.valueOf(this.capacity) : StringUtil.getFormat().format(this.capacity)))).withStyle(ChatFormatting.RED)));
    }
}

