/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.tinychests;

import com.devdyna.synergy.api.coreBE.block.BlockStorage;
import com.devdyna.synergy.init.builder.tinychests.TinyChestBE;
import com.devdyna.synergy.zStatic;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TinyChestBK
extends BlockStorage {
    public TinyChestBK() {
        super(BlockBehaviour.Properties.of().strength(1.0f).destroyTime(1.0f).sound(SoundType.WOOD).mapColor(MapColor.WOOD));
    }

    public TinyChestBK(BlockBehaviour.Properties p) {
        this();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext c) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)c.getHorizontalDirection().getOpposite());
    }

    protected VoxelShape getShape(BlockState s, BlockGetter l, BlockPos p, CollisionContext c) {
        return Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TinyChestBE(pos, state);
    }

    @Override
    protected Function<BlockBehaviour.Properties, Block> getFactory() {
        return TinyChestBK::new;
    }

    @Override
    protected void onClickAction(BlockState state, Level level, BlockPos pos, Player player) {
        level.playSound(player, pos, SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 1.0f, 1.75f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)("synergy." + zStatic.Blocks.tiny_wooden_chest)));
    }
}

