/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.sprinkler;

import com.devdyna.synergy.api.beLogic.EnergyBlock;
import com.devdyna.synergy.api.coreBE.be.TickingBE;
import com.devdyna.synergy.init.types.zBlockEntities;
import com.devdyna.synergy.init.types.zHandlers;
import com.devdyna.synergy.utils.LevelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.EnergyStorage;

public class SprinklerBE
extends TickingBE
implements EnergyBlock {
    private static int radius = 4;

    public SprinklerBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)zBlockEntities.SPRINKLER.get(), pos, state);
    }

    @Override
    public void tickServer() {
        int x2 = this.getBlockPos().getX();
        int y = this.getBlockPos().getY();
        int z = this.getBlockPos().getZ();
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(this.canExtract() && !this.level.hasNeighborSignal(this.getBlockPos()))));
        if (((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            BlockPos.randomBetweenClosed((RandomSource)this.level.random, (int)1, (int)(x2 - radius), (int)y, (int)(z - radius), (int)(x2 + radius), (int)(y + 2), (int)(z + radius)).forEach(pos -> {
                BlockState state = this.level.getBlockState(pos);
                if (state.isRandomlyTicking() && LevelUtil.chance(75, this.level)) {
                    if (LevelUtil.chance(25, this.level)) {
                        LevelUtil.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (ServerLevel)this.level, pos, true);
                    }
                    if (LevelUtil.chance(25, this.level)) {
                        this.level.playSound(null, this.getBlockPos(), SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 0.75f, 1.0f);
                    }
                    state.randomTick((ServerLevel)this.level, pos, this.level.random);
                    this.extractFE(25, false);
                }
            });
        }
    }

    public static int getRadius() {
        return radius;
    }

    @Override
    public ContainerData getContainerData() {
        return new SimpleContainerData(this.getMaxFE());
    }

    @Override
    public EnergyStorage getCapEnergy() {
        return (EnergyStorage)this.getData(zHandlers.ENERGY_STORAGE);
    }

    @Override
    public int MaxFE() {
        return 10000;
    }
}

