/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.solar_panel;

import com.devdyna.synergy.api.coreBE.block.TickingBlock;
import com.devdyna.synergy.init.builder.solar_panel.SolarPanelBE;
import com.devdyna.synergy.zStatic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SolarPanelBLK
extends TickingBlock {
    protected static ArrayList<BooleanProperty> PROPRTIES = new ArrayList<BooleanProperty>(Arrays.asList(BlockStateProperties.NORTH, BlockStateProperties.SOUTH, BlockStateProperties.EAST, BlockStateProperties.WEST));
    protected static ArrayList<Direction> DIRECTIONS = new ArrayList<Direction>(Arrays.asList(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST));

    public SolarPanelBLK() {
        super(BlockBehaviour.Properties.of().strength(1.0f).destroyTime(1.0f).sound(SoundType.METAL).mapColor(MapColor.METAL));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{BlockStateProperties.ENABLED});
        PROPRTIES.forEach(p -> b.add(new Property[]{p}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext c) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false));
        Level level = c.getLevel();
        BlockPos pos = c.getClickedPos();
        for (Direction face : DIRECTIONS) {
            BlockState offset = level.getBlockState(pos.relative(face));
            if (offset.is(state.getBlock())) {
                level.setBlockAndUpdate(pos.relative(face), (BlockState)offset.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face.getOpposite())), (Comparable)Boolean.valueOf(true)));
                continue;
            }
            state = (BlockState)state.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face)), (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    protected VoxelShape getShape(BlockState s, BlockGetter l, BlockPos p, CollisionContext c) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    }

    public void destroy(LevelAccessor l, BlockPos p, BlockState s) {
        for (Direction face : DIRECTIONS) {
            BlockState offset = l.getBlockState(p.relative(face));
            if (!offset.is(s.getBlock())) continue;
            l.setBlock(p.relative(face), (BlockState)offset.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face.getOpposite())), (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        for (Direction face : DIRECTIONS) {
            BlockState offset = level.getBlockState(pos.relative(face));
            if (offset.is(state.getBlock())) {
                level.setBlockAndUpdate(pos.relative(face), (BlockState)offset.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face.getOpposite())), (Comparable)Boolean.valueOf(true)));
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face)), (Comparable)Boolean.valueOf(true)));
                continue;
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face)), (Comparable)Boolean.valueOf(false)));
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p, BlockState s) {
        return new SolarPanelBE(p, s);
    }

    public BooleanProperty getProp(int i) {
        if (PROPRTIES.size() < i) {
            return null;
        }
        return PROPRTIES.get(i);
    }

    public void appendHoverText(ItemStack i, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        t.add((Component)Component.translatable((String)("synergy." + zStatic.Blocks.solar_panel)));
    }
}

