/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.solar_panel;

import com.devdyna.synergy.api.beLogic.EnergyProvider;
import com.devdyna.synergy.api.coreBE.be.TickingBE;
import com.devdyna.synergy.init.types.zBlockEntities;
import com.devdyna.synergy.init.types.zHandlers;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class SolarPanelBE
extends TickingBE
implements EnergyProvider {
    private final Map<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> cache = new HashMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>>();

    public SolarPanelBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)zBlockEntities.SOLAR_PANEL.get(), pos, state);
    }

    @Override
    public void tickServer() {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(this.canReceive() && this.level.isDay() && this.checkSky() && !this.level.hasNeighborSignal(this.getBlockPos()))));
        if (((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            this.increaseFE(64, false);
        }
        if (this.canExtract()) {
            this.providePowerAdjacent(this.level, this.getBlockPos(), this.cache, 64);
        }
    }

    public boolean checkSky() {
        return this.level.canSeeSkyFromBelowWater(this.getBlockPos().above()) && this.level.getBlockState(this.getBlockPos().above()).isAir();
    }

    @Override
    public ContainerData getContainerData() {
        return new SimpleContainerData(this.getMaxFE());
    }

    @Override
    public EnergyStorage getCapEnergy() {
        return (EnergyStorage)this.getData(zHandlers.ENERGY_STORAGE);
    }

    @Override
    public int MaxFE() {
        return 10000;
    }
}

