/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.reactor.moderator;

import com.devdyna.synergy.init.builder.reactor.cell.FuelCellBlock;
import com.devdyna.synergy.utils.LevelUtil;
import com.devdyna.synergy.zStatic;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public abstract class ModeratorBase
extends Block {
    public ModeratorBase() {
        super(BlockBehaviour.Properties.of().strength(1.0f).destroyTime(1.0f).sound(SoundType.CHAIN).mapColor(MapColor.METAL));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{BlockStateProperties.ENABLED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext c) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(this.checkForCells(c.getLevel(), c.getClickedPos())));
    }

    public boolean isActive(Level level, BlockPos pos) {
        return (Boolean)level.getBlockState(pos).getValue((Property)BlockStateProperties.ENABLED);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(this.checkForCells(level, pos))));
    }

    private boolean checkForCells(Level level, BlockPos pos) {
        return 0 < LevelUtil.predicateNeighborMatch(level, pos, b -> b instanceof FuelCellBlock);
    }

    public void appendHoverText(ItemStack i, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        if (Screen.hasShiftDown()) {
            t.add(this.conditions());
            t.add((Component)Component.translatable((String)("synergy." + zStatic.ReactorStuff.moderator + ".fe")).append("" + this.FEReducer()));
            t.add((Component)Component.translatable((String)("synergy." + zStatic.ReactorStuff.moderator + ".heat")).append("" + this.HeatReducer()));
        } else {
            t.add((Component)Component.translatable((String)("synergy." + zStatic.ReactorStuff.moderator)));
            t.add((Component)Component.translatable((String)("synergy." + zStatic.tips.SHIFT)));
        }
    }

    protected Component conditions() {
        return Component.translatable((String)("synergy." + zStatic.ReactorStuff.moderator + ".condition"));
    }

    public abstract float FEReducer();

    public abstract float HeatReducer();
}

