/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.reactor.cooler;

import com.devdyna.synergy.zStatic;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public abstract class CoolerBlockBase
extends Block {
    public CoolerBlockBase() {
        super(BlockBehaviour.Properties.of().strength(1.0f).destroyTime(1.0f).sound(SoundType.CHAIN).mapColor(MapColor.METAL));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{BlockStateProperties.ENABLED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext c) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(this.activeWhen(this.defaultBlockState(), c.getLevel(), c.getClickedPos())));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(this.activeWhen(state, level, pos))));
    }

    public abstract boolean activeWhen(BlockState var1, Level var2, BlockPos var3);

    public abstract int getActiveCooling();

    public int getBaseCooling() {
        return 0;
    }

    public abstract Component conditions();

    public boolean isActive(Level level, BlockPos pos) {
        return (Boolean)level.getBlockState(pos).getValue((Property)BlockStateProperties.ENABLED);
    }

    public void appendHoverText(ItemStack i, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        if (Screen.hasShiftDown()) {
            t.add(this.conditions());
            t.add((Component)Component.translatable((String)("synergy." + zStatic.ReactorStuff.cooler + ".off")).append("" + this.getBaseCooling()));
            t.add((Component)Component.translatable((String)("synergy." + zStatic.ReactorStuff.cooler + ".on")).append("" + this.getActiveCooling()));
        } else {
            t.add((Component)Component.translatable((String)("synergy." + zStatic.ReactorStuff.cooler + ".desc")));
            t.add((Component)Component.translatable((String)("synergy." + zStatic.tips.SHIFT)));
        }
    }
}

