/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.reactor.controller;

import com.devdyna.synergy.api.coreBE.block.TickingBlock;
import com.devdyna.synergy.api.reactor.ControllerProperties;
import com.devdyna.synergy.init.builder.reactor.controller.ReactorControllerBE;
import com.devdyna.synergy.utils.PlayerUtil;
import com.devdyna.synergy.utils.StringUtil;
import com.devdyna.synergy.zStatic;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class ReactorControllerBlock
extends TickingBlock {
    public static final EnumProperty<ControllerProperties> STATUS = EnumProperty.create((String)"status", ControllerProperties.class);

    public ReactorControllerBlock() {
        super(BlockBehaviour.Properties.of().forceSolidOn().destroyTime(1.0f).sound(SoundType.METAL).mapColor(MapColor.METAL));
    }

    public BlockState getStateForPlacement(BlockPlaceContext c) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false))).setValue(STATUS, (Comparable)((Object)ControllerProperties.WAITING))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)c.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, STATUS, BlockStateProperties.ENABLED});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!player.isShiftKeyDown() && !level.isClientSide && hand.equals((Object)InteractionHand.MAIN_HAND) && stack.isEmpty() && (blockEntity = level.getBlockEntity(pos)) instanceof ReactorControllerBE) {
            ReactorControllerBE be = (ReactorControllerBE)blockEntity;
            PlayerUtil.messageActionBar((be.heat > 0.0 ? "\u00a7c" : "\u00a7a") + StringUtil.getFormat().format(be.heat) + "\u00b0/t\u00a7f | \u00a76" + StringUtil.getFormat().format(be.fe) + "fe/t", player);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        ReactorControllerBE be = (ReactorControllerBE)level.getBlockEntity(pos);
        if (be.area != null) {
            be.updateCells(false);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p, BlockState s) {
        return new ReactorControllerBE(p, s);
    }

    public void appendHoverText(ItemStack i, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        t.add((Component)Component.translatable((String)("synergy." + zStatic.ReactorStuff.controller)));
    }
}

