/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.reactor.controller;

import com.devdyna.synergy.api.BiBool;
import com.devdyna.synergy.api.Range;
import com.devdyna.synergy.api.beLogic.AreaOfEffect;
import com.devdyna.synergy.api.beLogic.EnergyProvider;
import com.devdyna.synergy.api.coreBE.be.TickingBE;
import com.devdyna.synergy.api.reactor.ControllerProperties;
import com.devdyna.synergy.init.builder.reactor.cell.FuelCellBE;
import com.devdyna.synergy.init.builder.reactor.cell.FuelCellBlock;
import com.devdyna.synergy.init.builder.reactor.controller.ReactorControllerBlock;
import com.devdyna.synergy.init.builder.reactor.cooler.CoolerBlockBase;
import com.devdyna.synergy.init.builder.reactor.moderator.ModeratorBase;
import com.devdyna.synergy.init.recipeTypes.type.FuelCellRecipe;
import com.devdyna.synergy.init.types.zBlockEntities;
import com.devdyna.synergy.init.types.zHandlers;
import com.devdyna.synergy.utils.ColorUtil;
import com.devdyna.synergy.utils.LevelUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ReactorControllerBE
extends TickingBE
implements EnergyProvider,
AreaOfEffect {
    private final Map<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> cache = new HashMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>>();
    int i = 0;
    List<BlockPos> area = null;
    List<Integer> rgbColor;
    public int fe = 1;
    public double heat = 1.0;
    boolean isOverHeated;
    private List<BlockPos> cells = null;
    public int cellsCount;

    public ReactorControllerBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)zBlockEntities.REACTOR_CONTROLLER.get(), pos, state);
        int n = this.cellsCount = this.cells != null ? this.cells.size() : 0;
        if (this.radius == 0) {
            this.radius = 4;
        }
        Random random = new Random();
        Color color = ColorUtil.colorfulColorList.get(random.nextInt(ColorUtil.colorfulColorList.size()));
        this.rgbColor = List.of(Integer.valueOf(color.getRed()), Integer.valueOf(color.getGreen()), Integer.valueOf(color.getBlue()));
    }

    @Override
    public void tickServer() {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)this.getBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(this.canReceive() && this.area != null && this.level.hasNeighborSignal(this.getBlockPos())))).setValue(ReactorControllerBlock.STATUS, (Comparable)((Object)(this.enable() ? (this.isOverHeated ? ControllerProperties.OVERHEATED : (this.cellFound() ? ControllerProperties.PRODUCTION : ControllerProperties.NOFUEL)) : ControllerProperties.WAITING))));
        if (this.area == null) {
            this.area = this.getAreaSelection(this.level, (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING), this.getBlockPos());
        }
        if (this.enable()) {
            this.resetStats();
            this.checkBlocks(this.level);
        }
        if (this.is(ControllerProperties.PRODUCTION)) {
            this.increaseFE(this.fe, false);
            if (this.level.getGameTime() % 10L == 0L) {
                this.level.playSound(null, this.getBlockPos(), SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 1.0f * (LevelUtil.chance(50, this.level) ? 1.0f : 0.75f), 1.0f);
            }
        }
        if (this.canExtract()) {
            this.providePowerAdjacent(this.level, this.getBlockPos(), this.cache, this.getStoredFE());
        }
    }

    public void updateAOE() {
        this.area = null;
        this.resetStats();
    }

    private void resetStats() {
        this.isOverHeated = false;
        this.fe = 1;
        this.heat = 1.0;
        this.cells = new ArrayList<BlockPos>();
    }

    private void checkBlocks(Level level) {
        for (BlockPos pos : this.area) {
            BlockEntity blockEntity;
            Block block;
            if (LevelUtil.chance(1, level)) {
                LevelUtil.addDustParticle(this.rgbColor.get(0), this.rgbColor.get(1), this.rgbColor.get(2), (ServerLevel)level, pos, false, 1);
            }
            if ((block = level.getBlockState(pos).getBlock()) instanceof ReactorControllerBlock) {
                this.isOverHeated = true;
                return;
            }
            if (block instanceof CoolerBlockBase) {
                CoolerBlockBase cooler = (CoolerBlockBase)block;
                this.heat += (double)((Boolean)level.getBlockState(pos).getValue((Property)BlockStateProperties.ENABLED) != false ? cooler.getActiveCooling() : cooler.getBaseCooling());
            }
            if ((blockEntity = level.getBlockEntity(pos)) instanceof FuelCellBE) {
                FuelCellBE fuelcell = (FuelCellBE)blockEntity;
                Integer c = (Integer)level.getBlockState(pos).getValue((Property)FuelCellBlock.CELLS);
                if (fuelcell.hasRecipe()) {
                    this.cells.add(pos);
                    FuelCellRecipe recipe = (FuelCellRecipe)fuelcell.getRecipe().get().value();
                    this.fe += (1 + c) * recipe.getFe();
                    this.heat += (double)(1 + c) * recipe.getHeat();
                }
            }
            if (!(block instanceof ModeratorBase)) continue;
            ModeratorBase moderator = (ModeratorBase)block;
            if (!((Boolean)level.getBlockState(pos).getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) continue;
            this.fe = (int)((float)this.fe * moderator.FEReducer());
            this.heat *= (double)moderator.HeatReducer();
        }
        this.heat = (double)((int)(this.heat * 1000.0)) / 1000.0;
        this.fe = (int)((double)this.fe * (1.0 - this.heat * (double)0.001f));
        this.isOverHeated = this.heat > 0.0;
        this.updateCells(this.is(ControllerProperties.PRODUCTION));
    }

    public boolean cellFound() {
        return this.cells != null && !this.cells.isEmpty();
    }

    public void updateCells(boolean state) {
        if (this.cellFound()) {
            for (BlockPos pos : this.cells) {
                this.level.setBlockAndUpdate(pos, (BlockState)this.level.getBlockState(pos).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(state)));
            }
        }
    }

    public boolean is(ControllerProperties prop) {
        return ((ControllerProperties)((Object)this.getBlockState().getValue(ReactorControllerBlock.STATUS))).equals((Object)prop);
    }

    public boolean enable() {
        return (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED);
    }

    @Override
    public ContainerData getContainerData() {
        return new SimpleContainerData(this.getMaxFE());
    }

    @Override
    public EnergyStorage getCapEnergy() {
        return (EnergyStorage)this.getData(zHandlers.ENERGY_STORAGE);
    }

    @Override
    public int radius() {
        return this.radius;
    }

    @Override
    public int height() {
        return this.radius;
    }

    @Override
    public int MaxFE() {
        return 1000000;
    }

    @Override
    public Range radiusLimit() {
        return this.getRange();
    }

    @Override
    public Range heightLimit() {
        return this.getRange();
    }

    public Range getRange() {
        return Range.of(1, 8, BiBool.of(true, false));
    }
}

