/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.reactor.cell;

import com.devdyna.synergy.api.coreBE.block.MachineBlock;
import com.devdyna.synergy.init.builder.reactor.cell.FuelCellBE;
import com.devdyna.synergy.utils.LevelUtil;
import com.devdyna.synergy.zStatic;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class FuelCellBlock
extends MachineBlock {
    public static final IntegerProperty CELLS = IntegerProperty.create((String)"cells", (int)0, (int)6);

    public FuelCellBlock() {
        super(BlockBehaviour.Properties.of().strength(1.0f).destroyTime(1.0f).sound(SoundType.CHAIN).mapColor(MapColor.METAL));
    }

    public FuelCellBlock(BlockBehaviour.Properties p) {
        this();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{CELLS, BlockStateProperties.ENABLED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext c) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)CELLS, (Comparable)Integer.valueOf(this.getCells(c.getLevel(), c.getClickedPos())))).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CELLS, (Comparable)Integer.valueOf(this.getCells(level, pos))));
    }

    public int getCells(Level level, BlockPos pos) {
        return LevelUtil.predicateNeighborMatch(level, pos, b -> b instanceof FuelCellBlock);
    }

    public void appendHoverText(ItemStack i, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        t.add((Component)Component.translatable((String)("synergy." + zStatic.ReactorStuff.fuel_cell)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FuelCellBE(pos, state);
    }

    @Override
    protected Function<BlockBehaviour.Properties, Block> getFactory() {
        return FuelCellBlock::new;
    }

    @Override
    protected void onClickAction(BlockState state, Level level, BlockPos pos, Player player) {
    }
}

