/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.reactor.cell;

import com.devdyna.synergy.api.coreBE.be.MachineBE;
import com.devdyna.synergy.client.gui.fuel_cell.FuelCellMenu;
import com.devdyna.synergy.init.recipeTypes.input.MonoItemInput;
import com.devdyna.synergy.init.recipeTypes.type.FuelCellRecipe;
import com.devdyna.synergy.init.types.zBlockEntities;
import com.devdyna.synergy.init.types.zRecipeTypes;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FuelCellBE
extends MachineBE {
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    public static final String PROGRESS = "progress";
    public static final String RECIPE_INPUT = "recipe_input";
    private int progress = 0;
    private int maxProgress;
    private final ContainerData data = new ContainerData(){

        public int get(int i) {
            return switch (i) {
                case 0 -> FuelCellBE.this.getProgress();
                case 1 -> FuelCellBE.this.getMaxProgress();
                default -> 0;
            };
        }

        public void set(int i, int value) {
            switch (i) {
                case 0: {
                    FuelCellBE.this.setProgress(value);
                }
                case 1: {
                    FuelCellBE.this.setMaxProgress(value);
                }
            }
        }

        public int getCount() {
            return FuelCellBE.this.MachineSlots();
        }
    };
    private ItemStack inputStack;

    public FuelCellBE(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)zBlockEntities.FUEL_CELL.get(), pos, blockState);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FuelCellMenu(i, inventory, this, this.data);
    }

    @Override
    public void tickBoth() {
        if (this.level == null) {
            return;
        }
        this.saveItemInput();
        if (this.isReadyToWork()) {
            this.maxProgress = ((FuelCellRecipe)this.getRecipe().get().value()).getDuration();
            ++this.progress;
            FuelCellBE.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
            if (this.progress >= this.maxProgress) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    public void saveItemInput() {
        Optional recipe;
        ItemStack item = this.getStorage().getStackInSlot(0).copy();
        CompoundTag nbt = this.saveWithFullMetadata((HolderLookup.Provider)this.level.registryAccess());
        if (!item.isEmpty() && !nbt.contains(RECIPE_INPUT) && !(recipe = this.level.getRecipeManager().getRecipeFor(zRecipeTypes.FUEL_CELL_RECIPE.getType(), (RecipeInput)new MonoItemInput(item), this.level)).isEmpty() && this.canInsert(1, ((FuelCellRecipe)((RecipeHolder)recipe.get()).value()).getOutput())) {
            item.setCount(1);
            nbt.put(RECIPE_INPUT, item.save((HolderLookup.Provider)this.level.registryAccess()));
            this.loadWithComponents(nbt, (HolderLookup.Provider)this.level.registryAccess());
            FuelCellBE.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
            this.getStorage().extractItem(0, 1, false);
        }
    }

    public boolean isReadyToWork() {
        return this.hasRecipe() && (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED) != false;
    }

    public boolean isWorking() {
        return this.isReadyToWork() && this.progress < this.maxProgress && this.progress > 0;
    }

    private void craftItem() {
        ItemStack output = ((FuelCellRecipe)this.getRecipe().get().value()).getOutput();
        this.getStorage().setStackInSlot(1, new ItemStack((ItemLike)output.getItem(), this.getStorage().getStackInSlot(1).getCount() + output.getCount()));
        CompoundTag nbt = this.saveWithFullMetadata((HolderLookup.Provider)this.level.registryAccess());
        nbt.remove(RECIPE_INPUT);
        this.inputStack = ItemStack.EMPTY;
        this.loadWithComponents(nbt, (HolderLookup.Provider)this.level.registryAccess());
        FuelCellBE.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    private void resetProgress() {
        this.progress = 0;
    }

    @Override
    public int MachineSlots() {
        return 2;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public Optional<RecipeHolder<FuelCellRecipe>> getRecipe() {
        CompoundTag nbt = this.saveWithFullMetadata((HolderLookup.Provider)this.level.registryAccess());
        if (nbt.contains(RECIPE_INPUT)) {
            ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)nbt.getCompound(RECIPE_INPUT));
            return this.level.getRecipeManager().getRecipeFor(zRecipeTypes.FUEL_CELL_RECIPE.getType(), (RecipeInput)new MonoItemInput(item), this.level);
        }
        return Optional.empty();
    }

    public boolean hasRecipe() {
        return !this.getRecipe().isEmpty() && this.canInsert(1, ((FuelCellRecipe)this.getRecipe().get().value()).getOutput());
    }

    private boolean canInsert(int slotID, ItemStack output) {
        ItemStack slot = this.getStorage().getStackInSlot(slotID);
        return (slot.isEmpty() || slot.getItem() == output.getItem()) && (slot.isEmpty() ? 64 : slot.getMaxStackSize()) >= slot.getCount() + output.getCount();
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.putInt(PROGRESS, this.progress);
        if (this.inputStack != null && !this.inputStack.isEmpty()) {
            tag.put(RECIPE_INPUT, this.inputStack.save(pRegistries));
        }
        super.saveAdditional(tag, pRegistries);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.progress = tag.getInt(PROGRESS);
        this.inputStack = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound(RECIPE_INPUT));
    }
}

