/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.quern;

import com.devdyna.synergy.api.beLogic.ItemStorageBlock;
import com.devdyna.synergy.api.beLogic.NoGuiStorage;
import com.devdyna.synergy.api.coreBE.be.TickingBE;
import com.devdyna.synergy.init.recipeTypes.input.MonoItemInput;
import com.devdyna.synergy.init.recipeTypes.type.QuernMillingRecipe;
import com.devdyna.synergy.init.types.zBlockEntities;
import com.devdyna.synergy.init.types.zHandlers;
import com.devdyna.synergy.init.types.zRecipeTypes;
import com.devdyna.synergy.utils.LevelUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class QuernBE
extends TickingBE
implements ItemStorageBlock,
NoGuiStorage {
    private BlockCapabilityCache<IItemHandler, Direction> cache;
    private float rotation = 0.0f;
    private float speed = 0.0f;
    private int minDelay;
    private static final float MAX_SPEED = 10.0f;
    private static final float ACCEL = 0.1f;
    private static final float DECEL = 0.1f;

    public QuernBE(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public QuernBE(BlockPos pos, BlockState blockState) {
        this((BlockEntityType)zBlockEntities.QUERN.get(), pos, blockState);
    }

    @Override
    public ItemStackHandler getStorage() {
        return (ItemStackHandler)this.getData(zHandlers.ITEM_STORAGE);
    }

    @Override
    public int MachineSlots() {
        return 1;
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.getStorage().getSlots());
        inv.setItem(0, this.getStorage().getStackInSlot(0));
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.getBlockPos(), null);
        }
    }

    @Override
    public ItemStack insertItem(ItemStack stack) {
        return this.getStorage().insertItem(0, stack, false);
    }

    @Override
    public ItemStack extractItem() {
        ItemStack extracted = this.getStorage().extractItem(0, this.getStorage().getStackInSlot(0).getCount(), false);
        if (!extracted.isEmpty()) {
            return extracted;
        }
        return ItemStack.EMPTY;
    }

    public float getRotation(float partialTicks) {
        return this.rotation + this.speed * partialTicks;
    }

    @Override
    public void tickServer() {
        this.minDelay = ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue() ? ++this.minDelay : 0;
        if (this.level == null || this.cache == null) {
            return;
        }
        IItemHandler slot = (IItemHandler)this.cache.getCapability();
        if (slot == null) {
            return;
        }
        ItemStack item = slot.getStackInSlot(0);
        if (!item.isEmpty()) {
            Optional recipe = this.level.getRecipeManager().getRecipeFor(zRecipeTypes.QUERN_MILLING.getType(), (RecipeInput)new MonoItemInput(item), this.level);
            boolean flag = !recipe.isEmpty();
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(flag)));
            if (LevelUtil.chance(75, this.level) && flag) {
                if (this.level.getGameTime() % 15L + (long)(LevelUtil.chance(50, this.level) ? 0 : 5) == 0L) {
                    this.level.playSound(null, this.getBlockPos(), SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 0.25f * (LevelUtil.chance(50, this.level) ? 1.0f : 0.75f), 1.0f);
                }
                if (this.minDelay >= ((QuernMillingRecipe)((RecipeHolder)recipe.get()).value()).getTime() && this.minDelay % ((QuernMillingRecipe)((RecipeHolder)recipe.get()).value()).getTime() == 0) {
                    ItemStack output = ((QuernMillingRecipe)((RecipeHolder)recipe.get()).value()).getOutput();
                    LevelUtil.popItemFromPos(this.level, this.getBlockPos(), output.copy());
                    slot.extractItem(0, 1, false);
                    this.level.playSound(null, this.getBlockPos(), SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.5f * (LevelUtil.chance(50, this.level) ? 1.0f : 0.75f), 1.0f);
                    QuernBE.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
                }
            }
        } else {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public void tickClient() {
        if (((Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            if (this.speed < 10.0f) {
                this.speed += 0.1f;
            }
        } else {
            if (this.speed > 0.0f) {
                this.speed -= 0.1f;
            }
            if (this.speed < 0.0f) {
                this.speed = 0.0f;
            }
        }
        this.rotation += this.speed;
        if (this.rotation >= 360.0f) {
            this.rotation -= 360.0f;
        }
    }
}

