/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder.harvester;

import com.devdyna.synergy.api.BiBool;
import com.devdyna.synergy.api.Range;
import com.devdyna.synergy.api.beLogic.AreaOfEffect;
import com.devdyna.synergy.api.beLogic.EnergyBlock;
import com.devdyna.synergy.api.beLogic.ItemProducer;
import com.devdyna.synergy.api.coreBE.be.TickingBE;
import com.devdyna.synergy.api.harvester.PlantHandler;
import com.devdyna.synergy.api.harvester.VanillaPlants;
import com.devdyna.synergy.init.types.zBlockEntities;
import com.devdyna.synergy.init.types.zHandlers;
import com.devdyna.synergy.utils.ColorUtil;
import com.devdyna.synergy.utils.LevelUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;

public class HarvesterBE
extends TickingBE
implements EnergyBlock,
AreaOfEffect,
ItemProducer {
    private final Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> cache = new HashMap<Direction, BlockCapabilityCache<IItemHandler, Direction>>();
    int i = 0;
    List<BlockPos> area = null;
    boolean soundToggle = false;
    List<Integer> rgbColor;
    int delay = 5;

    public HarvesterBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)zBlockEntities.HARVESTER.get(), pos, state);
        Random random = new Random();
        Color color = ColorUtil.colorfulColorList.get(random.nextInt(ColorUtil.colorfulColorList.size()));
        this.rgbColor = List.of(Integer.valueOf(color.getRed()), Integer.valueOf(color.getGreen()), Integer.valueOf(color.getBlue()));
    }

    @Override
    public void tickServer() {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(this.area != null && this.canExtract() && !this.level.hasNeighborSignal(this.getBlockPos()))));
        if (this.area == null) {
            this.area = this.getAreaSelection(this.level, (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING), this.getBlockPos());
        }
        if (((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            this.checkBlocks(this.level);
            this.extractFE(25, false);
        }
    }

    public List<ItemStack> collectItemDrops(Level level, BlockPos pos) {
        ArrayList<List> list = new ArrayList<List>(Arrays.asList(VanillaPlants.checkReplant(level, pos), VanillaPlants.checkNoReplant(level, pos), VanillaPlants.checkTree(level, pos), VanillaPlants.checkBigPlant(level, pos), this.getAPICrops(level, pos)));
        for (List check : list) {
            if (check == null) continue;
            return check;
        }
        return null;
    }

    public List<ItemStack> getAPICrops(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof PlantHandler) {
            PlantHandler plant = (PlantHandler)block;
            return plant.execute(level, pos);
        }
        return null;
    }

    private void checkBlocks(Level level) {
        int size = this.area.size();
        if (this.i < size && level.getGameTime() % (long)this.delay == 0L) {
            LevelUtil.addDustParticle(this.rgbColor.get(0), this.rgbColor.get(1), this.rgbColor.get(2), (ServerLevel)level, this.area.get(this.i), false, 4);
            List<ItemStack> items = this.collectItemDrops(level, this.area.get(this.i));
            if (items != null) {
                for (ItemStack itemStack : this.unifyDrops(items)) {
                    this.exportItems(itemStack, List.of((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)), level, this.getBlockPos(), this.cache);
                }
            }
            level.playSound(null, this.getBlockPos(), this.soundToggle ? SoundEvents.COPPER_BULB_TURN_ON : SoundEvents.COPPER_BULB_TURN_OFF, SoundSource.BLOCKS);
            this.soundToggle = !this.soundToggle;
            ++this.i;
        }
        if (this.i >= size) {
            this.i = 0;
        }
    }

    @Override
    public ContainerData getContainerData() {
        return new SimpleContainerData(this.getMaxFE());
    }

    @Override
    public EnergyStorage getCapEnergy() {
        return (EnergyStorage)this.getData(zHandlers.ENERGY_STORAGE);
    }

    @Override
    public int radius() {
        return 4;
    }

    @Override
    public int height() {
        return 1;
    }

    @Override
    public boolean dropWhenFail() {
        return true;
    }

    @Override
    public int MaxFE() {
        return 10000;
    }

    @Override
    public Range radiusLimit() {
        return Range.of(1, 6, BiBool.of(true, false));
    }

    @Override
    public Range heightLimit() {
        return Range.of(1, 8, BiBool.of(true, false));
    }
}

