/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init.builder;

import com.devdyna.synergy.utils.LevelUtil;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class DryableBricks
extends HorizontalDirectionalBlock {
    public static final IntegerProperty DRY_STAGE = IntegerProperty.create((String)"stage", (int)0, (int)5);
    public static final BooleanProperty DRIED = BooleanProperty.create((String)"dried");
    public static final BooleanProperty WET = BooleanProperty.create((String)"wet");

    public DryableBricks(BlockBehaviour.Properties p) {
        super(p.randomTicks().instabreak().pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)DRIED, (Comparable)Boolean.valueOf(false))).setValue((Property)WET, (Comparable)Boolean.valueOf(false))).setValue((Property)DRY_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected VoxelShape getShape(BlockState s, BlockGetter l, BlockPos p, CollisionContext c) {
        return ((Direction)s.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? Block.box((double)3.5, (double)0.0, (double)5.5, (double)12.5, (double)2.0, (double)10.5) : Block.box((double)5.5, (double)0.0, (double)3.5, (double)10.5, (double)2.0, (double)12.5);
    }

    public BlockState getStateForPlacement(BlockPlaceContext c) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)c.getHorizontalDirection())).setValue((Property)DRIED, (Comparable)Boolean.valueOf(false))).setValue((Property)WET, (Comparable)Boolean.valueOf(DryableBricks.getConditions(c.getLevel(), c.getClickedPos().above())))).setValue((Property)DRY_STAGE, (Comparable)Integer.valueOf(0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{FACING, DRIED, DRY_STAGE, WET});
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WET, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)DRIED) == false && DryableBricks.getConditions((Level)level, pos))));
        if (((Boolean)state.getValue((Property)WET)).booleanValue()) {
            if ((Integer)state.getValue((Property)DRY_STAGE) != 0) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DRY_STAGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)DRY_STAGE) - 1)));
            }
        } else if (LevelUtil.chance(25, (Level)level) && (Integer)state.getValue((Property)DRY_STAGE) != 5) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DRY_STAGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)DRY_STAGE) + 1)));
        }
        if ((Integer)state.getValue((Property)DRY_STAGE) == 5) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DRIED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (LevelUtil.chance(15, level) && this.isRandomlyTicking(state)) {
            level.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return DryableBricks.simpleCodec(p -> this);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)DRIED) == false;
    }

    public static boolean getConditions(Level level, BlockPos pos) {
        boolean seesky;
        boolean drybiome = level.getBiome(pos).is(Tags.Biomes.IS_DRY);
        boolean bl = level.canSeeSkyFromBelowWater(pos.above()) ? !level.isRaining() : (seesky = level.isRaining());
        return LevelUtil.chance(25, level) ? !drybiome || !seesky : false;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.isClientSide) {
            return;
        }
        if (!Block.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP)) {
            DryableBricks.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
            level.removeBlock(pos, false);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && ((Boolean)state.getValue((Property)DRIED)).booleanValue()) {
            level.removeBlock(pos, false);
            Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null).forEach(i -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)i));
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"synergy.disabled"));
    }
}

