/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.init;

import com.devdyna.synergy.init.builder.DecorativeBlock;
import com.devdyna.synergy.init.builder.ItemComponents;
import com.devdyna.synergy.init.builder.ItemToolTipped;
import com.devdyna.synergy.init.types.zBlockEntities;
import com.devdyna.synergy.init.types.zBlockTag;
import com.devdyna.synergy.init.types.zBlocks;
import com.devdyna.synergy.init.types.zComponents;
import com.devdyna.synergy.init.types.zContainer;
import com.devdyna.synergy.init.types.zCreativeTab;
import com.devdyna.synergy.init.types.zFluidTags;
import com.devdyna.synergy.init.types.zFluids;
import com.devdyna.synergy.init.types.zHandlers;
import com.devdyna.synergy.init.types.zItemTag;
import com.devdyna.synergy.init.types.zItems;
import com.devdyna.synergy.init.types.zRecipeTypes;
import com.devdyna.synergy.zStatic;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Material {
    public static void register(IEventBus bus) {
        zBlockEntities.register(bus);
        zItems.register(bus);
        zBlocks.register(bus);
        zBlockTag.register(bus);
        zContainer.register(bus);
        zFluidTags.register(bus);
        zFluids.register(bus);
        zHandlers.register(bus);
        zItemTag.register(bus);
        zComponents.register(bus);
        zCreativeTab.register(bus);
        zRecipeTypes.register(bus);
    }

    public static DeferredHolder<Block, Block> registerItemBlock(String blockname, Supplier<Block> sup) {
        return Material.registerItemBlock(blockname, sup, zBlocks.zBlockItem);
    }

    public static DeferredHolder<Block, Block> registerItemBlock(String blockname, Supplier<Block> sup, DeferredRegister.Blocks b) {
        DeferredBlock block = b.register(blockname, sup);
        zItems.zBlockItem.registerSimpleBlockItem((Holder)block);
        return block;
    }

    public static DeferredHolder<Block, Block> registerItemBlock(String blockname, DeferredRegister.Blocks b) {
        return Material.registerItemBlock(blockname, () -> new Block(BlockBehaviour.Properties.of()), b);
    }

    public static TagKey<Item> tagItem(String name) {
        return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"synergy", (String)name));
    }

    public static TagKey<Block> tagBlock(String name) {
        return TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"synergy", (String)name));
    }

    public static TagKey<Item> tagItem(String name, String modname) {
        return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modname, (String)name));
    }

    public static TagKey<Block> tagBlock(String name, String modname) {
        return TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modname, (String)name));
    }

    public static TagKey<Fluid> tagFluid(String name) {
        return TagKey.create((ResourceKey)BuiltInRegistries.FLUID.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"synergy", (String)name));
    }

    public static DeferredItem<ItemNameBlockItem> seedFoodItem(String name, Block b, int nutrition, float saturationModifier, boolean fastToEat, boolean isAlwaysEdible) {
        FoodProperties.Builder food = new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturationModifier);
        if (fastToEat) {
            food.fast();
        }
        if (isAlwaysEdible) {
            food.alwaysEdible();
        }
        return zItems.zFoods.register(name, () -> new ItemNameBlockItem(b, new Item.Properties().food(food.build())));
    }

    public static DeferredItem<ItemNameBlockItem> seedItem(String name, Block b) {
        return zItems.zSeeds.register(name, () -> new ItemNameBlockItem(b, new Item.Properties()));
    }

    public static DeferredHolder<Block, Block> stair(DeferredHolder<Block, Block> b) {
        return Material.registerItemBlock(b.getRegisteredName().replace("synergy:", "") + "_stair", () -> new StairBlock(((Block)b.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)b.get()))), zBlocks.zBlockStair);
    }

    public static DeferredHolder<Block, Block> slab(DeferredHolder<Block, Block> b) {
        return Material.registerItemBlock(b.getRegisteredName().replace("synergy:", "") + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)b.get()))), zBlocks.zBlockSlab);
    }

    public static DeferredHolder<Block, Block> DecoBlock(String name, BlockBehaviour.Properties prop, DeferredRegister.Blocks blockSets) {
        return Material.registerItemBlock(name, () -> new DecorativeBlock(prop), blockSets);
    }

    public static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> createBlockEntity(String name, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<? extends Block> ... validBlocks) {
        return zBlockEntities.zBE.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])((Block[])Arrays.stream(validBlocks).map(Supplier::get).toArray(Block[]::new))).build(null));
    }

    public static DeferredHolder<Item, Item> craftingItem(String name) {
        return zItems.zCraftingComponents.register(name, () -> new ItemComponents());
    }

    public static DeferredHolder<Item, Item> tooltippedItem(String name, DeferredRegister.Items i) {
        return i.register(name, () -> new ItemToolTipped(name + ".tip"));
    }

    public static DeferredHolder<Item, Item> resourceItem(String name) {
        return zItems.zResources.registerSimpleItem(name);
    }

    public static DeferredHolder<Item, Item> droplet(String name) {
        return zItems.zDropLets.registerSimpleItem(name);
    }

    public static DeferredHolder<Item, Item> resourceFoil(String name) {
        return zItems.zFoils.registerSimpleItem(name + zStatic.ResourceType.foil);
    }

    public static DeferredHolder<Item, Item> resourceGem(String name) {
        return zItems.zGems.registerSimpleItem(name + zStatic.ResourceType.gem);
    }

    public static DeferredHolder<Item, Item> resourceIngot(String name) {
        return zItems.zIngots.registerSimpleItem(name + zStatic.ResourceType.ingot);
    }

    public static DeferredHolder<Item, Item> resourceNugget(String name) {
        return zItems.zNuggets.registerSimpleItem(name + zStatic.ResourceType.nugget);
    }

    public static DeferredHolder<Item, Item> resourcePlate(String name) {
        return zItems.zPlates.registerSimpleItem(name + zStatic.ResourceType.plate);
    }

    public static DeferredHolder<Item, Item> resourceRaw(String name) {
        return zItems.zRawOres.registerSimpleItem(zStatic.ResourceType.raw + name);
    }

    public static DeferredHolder<Item, Item> resourceShard(String name) {
        return zItems.zShards.registerSimpleItem(name + zStatic.ResourceType.shard);
    }

    public static DeferredHolder<Item, Item> resourceDust(String name) {
        return zItems.zDusts.registerSimpleItem(name + zStatic.ResourceType.dust);
    }

    public static DeferredHolder<Item, Item> resourcePellet(String name) {
        return zItems.zPellets.registerSimpleItem(name + zStatic.ResourceType.pellet);
    }
}

