/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.events;

import com.devdyna.synergy.config.Common;
import com.devdyna.synergy.init.recipeTypes.input.UseItemInput;
import com.devdyna.synergy.init.recipeTypes.type.ItemUseRecipe;
import com.devdyna.synergy.init.types.zRecipeTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ItemUseRecipeEvent {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void potAction(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        Player player = event.getEntity();
        ItemStack item = event.getItemStack();
        InteractionHand hand = event.getHand();
        BlockState state = level.getBlockState(pos);
        Optional recipe = level.getRecipeManager().getRecipeFor(zRecipeTypes.ITEM_USE.getType(), (RecipeInput)new UseItemInput(state, item), level);
        if (!recipe.isEmpty()) {
            ItemUseRecipe rcp = (ItemUseRecipe)((RecipeHolder)recipe.get()).value();
            if (rcp.canBeDisabled() && ((Boolean)Common.DISABLE_ITEM_USE_RECIPE.get()).booleanValue()) {
                return;
            }
            if (!player.isCreative()) {
                item.shrink(1);
            }
            BlockState output = rcp.getOutputState();
            try {
                for (int i = 0; i < 8; ++i) {
                    level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, output), (double)pos.getX() + 0.25, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.25, 1.0, 1.0, 1.0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), output.getSoundType((LevelReader)level, pos, (Entity)player).getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            player.swing(hand);
            level.setBlockAndUpdate(pos, output);
            event.isCanceled();
            event.setCanceled(true);
        }
    }
}

