/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.events;

import com.devdyna.synergy.init.builder.DryableBricks;
import com.devdyna.synergy.init.recipeTypes.input.MonoItemInput;
import com.devdyna.synergy.init.recipeTypes.type.DryableBricksRecipe;
import com.devdyna.synergy.init.types.zRecipeTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ClayBrickPlacement {
    @SubscribeEvent
    public static void claybrickplacement(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        ItemStack item = player.getMainHandItem();
        Direction dir = event.getFace();
        BlockState block = level.getBlockState(pos.relative(dir));
        InteractionHand hand = event.getHand();
        Optional recipe = level.getRecipeManager().getRecipeFor(zRecipeTypes.DRYABLE_BRICKS.getType(), (RecipeInput)new MonoItemInput(item), level);
        if (recipe.isEmpty()) {
            return;
        }
        BlockState result = ((DryableBricksRecipe)((RecipeHolder)recipe.get()).value()).getBlock();
        if (!block.isEmpty() && !block.isAir()) {
            return;
        }
        if (!Block.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(dir).below(), (Direction)Direction.UP)) {
            return;
        }
        if (!player.isCreative()) {
            item.shrink(1);
        }
        player.swing(hand);
        SoundType soundType = result.getSoundType((LevelReader)level, pos, (Entity)player);
        level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        level.setBlockAndUpdate(pos.relative(dir), (BlockState)((BlockState)((BlockState)((BlockState)result.setValue((Property)DryableBricks.DRIED, (Comparable)Boolean.valueOf(false))).setValue((Property)DryableBricks.DRY_STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)DryableBricks.WET, (Comparable)Boolean.valueOf(DryableBricks.getConditions(level, pos)))).setValue((Property)DryableBricks.FACING, (Comparable)player.getDirection()));
    }
}

