/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.datagen.server;

import com.devdyna.synergy.api.plants.builder.BaseCropBlock;
import com.devdyna.synergy.api.plants.builder.BaseShortCropBlock;
import com.devdyna.synergy.init.builder.DryableBricks;
import com.devdyna.synergy.init.types.zBlocks;
import com.devdyna.synergy.init.types.zItems;
import com.devdyna.synergy.utils.DataGenUtil;
import com.devdyna.synergy.utils.EnchantUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DataLootBlock
extends BlockLootSubProvider {
    List<DeferredRegister.Blocks> blocktypes = List.of(zBlocks.zBlock, zBlocks.zBlockItem, zBlocks.zCrop, zBlocks.zHiddenBlock, zBlocks.zWildCrop, zBlocks.zDecorative, zBlocks.zBlockStair, zBlocks.zBlockSlab, zBlocks.zCoolers, zBlocks.zModerators, zBlocks.zDepositBlocks, zBlocks.zDepositOres);

    public DataLootBlock(HolderLookup.Provider l) {
        super(Set.of(), FeatureFlags.DEFAULT_FLAGS, l);
    }

    protected Iterable<Block> getKnownBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        this.blocktypes.forEach(t -> blocks.addAll(t.getEntries().stream().map(DeferredHolder::get).toList()));
        return blocks;
    }

    protected void generate() {
        Set<DeferredHolder> dropSelfBlocks = Set.of(zBlocks.BASIC_MACHINE_FRAME, zBlocks.PIPE, zBlocks.ITEM_PROVIDER, zBlocks.ITEM_RETRIEVAL, zBlocks.ITEM_TRANSFER, zBlocks.ENERGY_RETRIEVAL, zBlocks.ENERGY_TRANSFER, zBlocks.FLUID_PROVIDER, zBlocks.FLUID_RETRIEVAL, zBlocks.FLUID_TRANSFER, zBlocks.SOLAR_PANEL, zBlocks.HARVESTER, zBlocks.SPRINKLER, zBlocks.HEALER, zBlocks.REACTOR_CONTROLLER, zBlocks.REACTOR_FUEL_CELL, zBlocks.COOLER_BASE, zBlocks.WOODEN_TINY_CHEST, zBlocks.ORNATE_TINY_CHEST, zBlocks.STONE_TINY_CHEST, zBlocks.ADVANCED_MACHINE_FRAME, zBlocks.URN, zBlocks.QUERN);
        dropSelfBlocks.forEach(b -> this.dropSelf((Block)b.get()));
        List<DeferredRegister.Blocks> types2 = List.of(zBlocks.zModerators, zBlocks.zCoolers, zBlocks.zBlockSlab, zBlocks.zBlockStair, zBlocks.zDecorative);
        types2.forEach(t -> t.getEntries().forEach(b -> this.dropSelf((Block)b.get())));
        this.azalea();
        this.cropDrop7((Block)zBlocks.RICE.get(), (Item)zItems.RICE_SEED.get(), (Item)zItems.RICE_SEED.get());
        this.cropDrop5((Block)zBlocks.BLUE_CUP_MUSHROOM.get(), (Item)zItems.BLUE_CUP_SPORE.get(), (Item)zItems.BLUE_CUP_MUSHROOM.get());
        this.cropDrop5((Block)zBlocks.VIOLET_WEBCAP_MUSHROOM.get(), (Item)zItems.VIOLET_WEBCAP_SPORE.get(), (Item)zItems.VIOLET_WEBCAP_MUSHROOM.get());
        this.cropDrop5((Block)zBlocks.CAVE_WHEAT.get(), (Item)zItems.CAVE_WHEAT_SEEDS.get(), Items.WHEAT);
        this.cropDrop5((Block)zBlocks.COTTON.get(), (Item)zItems.COTTON_SEEDS.get(), (Item)zItems.COTTON.get());
        this.cropDropNoConditions((Block)zBlocks.WILD_RICE.get(), (Item)zItems.RICE_SEED.get(), (Item)zItems.RICE_SEED.get());
        this.cropDropNoConditions((Block)zBlocks.WILD_CAVE_WHEAT.get(), (Item)zItems.CAVE_WHEAT_SEEDS.get(), Items.WHEAT);
        this.cropDropNoConditions((Block)zBlocks.WILD_COTTON.get(), (Item)zItems.COTTON_SEEDS.get(), (Item)zItems.COTTON.get());
        this.brick(zBlocks.CLAY_BRICK, Items.CLAY_BALL, Items.BRICK);
        this.brick(zBlocks.PACKED_MUD_BRICK, (Item)zItems.PACKED_MUD_BALL.get(), (Item)zItems.PACKED_MUD_BRICK.get());
    }

    private void brick(DeferredHolder<Block, Block> b, Item fail, Item success) {
        this.add((Block)b.get(), LootTable.lootTable().withPool(DataGenUtil.createPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)fail)).when((LootItemCondition.Builder)DataGenUtil.lootTableConditionInverse((Block)b.get(), DryableBricks.DRIED)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).withPool(DataGenUtil.createPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)success)).when((LootItemCondition.Builder)DataGenUtil.lootTableCondition((Block)b.get(), DryableBricks.DRIED)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))));
    }

    private void azalea() {
        this.add((Block)zBlocks.AZALEA.get(), LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)Items.FLOWER_POT, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLOWER_POT)))).withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)zItems.AZALEA_SEEDS.get(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)zItems.AZALEA_SEEDS.get()))))).withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)zItems.SMALL_AZALEA_LEAF.get(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)zItems.SMALL_AZALEA_LEAF.get()))))).withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)zItems.SMALL_AZALEA_ROOTS.get(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)zItems.SMALL_AZALEA_ROOTS.get()))))));
    }

    private void cropDrop5(Block b, Item seed, Item ... items) {
        this.cropDrop(b, (LootItemCondition.Builder)DataGenUtil.lootTableCondition(b, BaseShortCropBlock.AGE, 5), seed, 1, 3, items);
    }

    private void cropDrop7(Block b, Item seed, Item ... items) {
        this.cropDrop(b, (LootItemCondition.Builder)DataGenUtil.lootTableCondition(b, BaseCropBlock.AGE, 7), seed, 1, 3, items);
    }

    private void cropDrop(Block b, LootItemCondition.Builder builder, Item seed, int min, int max, Item ... items) {
        LootTable.Builder table = LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)seed).when(builder)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount(EnchantUtil.getEnchantHolder(this.registries, (ResourceKey<Enchantment>)Enchantments.FORTUNE)))));
        for (Item item : items) {
            table = table.withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)item).when(builder)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount(EnchantUtil.getEnchantHolder(this.registries, (ResourceKey<Enchantment>)Enchantments.FORTUNE))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seed))));
        }
        this.add(b, (LootTable.Builder)this.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)table));
    }

    private void cropDropNoConditions(Block b, int min, int max, Item ... items) {
        LootTable.Builder table = LootTable.lootTable();
        for (Item item : items) {
            table = table.withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max)))).when(BonusLevelTableCondition.bonusLevelFlatChance(EnchantUtil.getEnchantHolder(this.registries, (ResourceKey<Enchantment>)Enchantments.FORTUNE), (float[])new float[]{2.0f})));
        }
        this.add(b, (LootTable.Builder)this.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)table));
    }

    private void cropDropNoConditions(Block b, Item ... items) {
        this.cropDropNoConditions(b, 1, 3, items);
    }
}

