/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.datagen;

import com.devdyna.synergy.datagen.client.DataBlockModelState;
import com.devdyna.synergy.datagen.client.DataItemModel;
import com.devdyna.synergy.datagen.client.DataLang;
import com.devdyna.synergy.datagen.server.DataAnyLoot;
import com.devdyna.synergy.datagen.server.DataBlockTag;
import com.devdyna.synergy.datagen.server.DataGlobalLootModifier;
import com.devdyna.synergy.datagen.server.DataItemTag;
import com.devdyna.synergy.datagen.server.DataLootBlock;
import com.devdyna.synergy.datagen.server.DataMaps;
import com.devdyna.synergy.datagen.server.DataRecipe;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="synergy")
public class Controller {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent e) {
        DataGenerator g = e.getGenerator();
        PackOutput po = g.getPackOutput();
        ExistingFileHelper f = e.getExistingFileHelper();
        CompletableFuture pr = e.getLookupProvider();
        Controller.providerGen(e, g, new DataBlockModelState(po, f));
        Controller.providerGen(e, g, new DataItemModel(po, f));
        Controller.providerGen(e, g, new DataLang(po));
        DataBlockTag blocktag = new DataBlockTag(po, pr, f);
        Controller.providerGen(e, g, blocktag);
        Controller.providerGen(e, g, new DataItemTag(po, pr, blocktag.contentsGetter(), f));
        Controller.providerGen(e, g, new LootTableProvider(po, Set.of(), List.of(new LootTableProvider.SubProviderEntry(DataLootBlock::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(DataAnyLoot::new, LootContextParamSets.ENTITY)), pr));
        Controller.providerGen(e, g, new DataRecipe(po, pr));
        Controller.providerGen(e, g, new DataMaps(po, pr));
        Controller.providerGen(e, g, new DataGlobalLootModifier(po, pr));
    }

    private static <T extends DataProvider> void providerGen(GatherDataEvent e, DataGenerator g, T f) {
        g.addProvider(e.includeClient(), f);
    }
}

