/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.compat.jei.drawable;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ListedIcons
implements IDrawable {
    private Item[] items = new Item[]{Items.STONE, Items.COBBLESTONE};
    private List<IDrawable> icons;
    private ITickTimer timer;
    private int delay = 40;
    private boolean reverse = false;

    public static ListedIcons of() {
        return new ListedIcons();
    }

    public ListedIcons setIcons(Item ... items) {
        this.items = items;
        return this;
    }

    public ListedIcons setDelay(int ticks) {
        this.delay = ticks;
        return this;
    }

    public ListedIcons setReverse() {
        this.reverse = true;
        return this;
    }

    public ListedIcons setup(IGuiHelper guiHelper) {
        this.icons = Arrays.stream(this.items).map(arg_0 -> ((IGuiHelper)guiHelper).createDrawableItemLike(arg_0)).toList();
        this.timer = guiHelper.createTickTimer(this.delay, this.icons.size() - 1, this.reverse);
        return this;
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        this.icons.get(this.timer.getValue()).draw(guiGraphics, xOffset, yOffset);
    }

    public <T> ListedIcons fromTypes(IGuiHelper guiHelper, DeferredRegister<T> r) {
        return ListedIcons.of().setDelay(this.delay).setIcons((Item[])r.getEntries().stream().map(DeferredHolder::get).toArray(Item[]::new)).setup(guiHelper);
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }
}

