/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.compat.jei.categories;

import com.devdyna.synergy.client.gui.screenLocations;
import com.devdyna.synergy.compat.jei.categories.core.BaseRecipeCategory;
import com.devdyna.synergy.compat.jei.drawable.SimpleIcon;
import com.devdyna.synergy.init.recipeTypes.type.FuelCellRecipe;
import com.devdyna.synergy.init.types.zItems;
import com.devdyna.synergy.init.types.zRecipeTypes;
import com.devdyna.synergy.utils.x;
import com.devdyna.synergy.zStatic;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class ReactorCellCategory
extends BaseRecipeCategory<FuelCellRecipe> {
    private IDrawableAnimated arrow;
    public static final RecipeType<FuelCellRecipe> TYPE = new RecipeType(x.rl(zRecipeTypes.FUEL_CELL_RECIPE.getId()), FuelCellRecipe.class);

    public ReactorCellCategory(IGuiHelper helper) {
        super(helper);
        this.arrow = helper.drawableBuilder(screenLocations.GREEN_PROGRESS_ARROW, 0, 0, 24, 16).setTextureSize(24, 16).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<FuelCellRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)("synergy.jei." + zStatic.ReactorStuff.fuel_cell));
    }

    @Nullable
    public IDrawable getIcon() {
        return SimpleIcon.of(this.helper, (Item)zItems.URANIUM.get());
    }

    @Nullable
    public IDrawable getBackground() {
        return this.helper.createDrawable(screenLocations.JEI_DARK_SLOTS, 0, 0, 128, 64);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FuelCellRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 34, 17).addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 84, 17).addItemStack(recipe.getOutput());
    }

    public void draw(FuelCellRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.drawString(this.font, (String)(recipe.getDuration() == 1 ? "no tick delay" : (recipe.getDuration() >= 20 ? (recipe.getDuration() >= 1200 ? (recipe.getDuration() >= 72000 ? recipe.getDuration() / 72000 + " hour" + (recipe.getDuration() > 72000 ? "s" : "") : recipe.getDuration() / 1200 + " minute" + (recipe.getDuration() > 1200 ? "s" : "")) : recipe.getDuration() / 20 + " second" + (recipe.getDuration() > 20 ? "s" : "")) : recipe.getDuration() + " tick" + (recipe.getDuration() > 1 ? "s" : ""))), 45, 5, 0xA0A0A0);
        guiGraphics.drawString(this.font, "Heat " + (recipe.getHeat() >= 0.0 ? "+" : "") + recipe.getHeat() + "\u00b0/t", 25, 40, 0xA0A0A0);
        guiGraphics.drawString(this.font, "Gen  " + (recipe.getFe() >= 0 ? "+" : "") + recipe.getFe() + "fe/t", 25, 50, 0xA0A0A0);
        this.arrow.draw(guiGraphics, 53, 17);
    }
}

