/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.compat.jei.categories;

import com.devdyna.synergy.api.Pos;
import com.devdyna.synergy.client.gui.screenLocations;
import com.devdyna.synergy.compat.jei.categories.core.BaseRecipeCategory;
import com.devdyna.synergy.compat.jei.drawable.SimpleIcon;
import com.devdyna.synergy.init.recipeTypes.type.ItemUseRecipe;
import com.devdyna.synergy.init.types.zRecipeTypes;
import com.devdyna.synergy.utils.x;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class ItemUseCategory
extends BaseRecipeCategory<ItemUseRecipe> {
    public static final RecipeType<ItemUseRecipe> TYPE = new RecipeType(x.rl(zRecipeTypes.ITEM_USE.getId()), ItemUseRecipe.class);

    public ItemUseCategory(IGuiHelper helper) {
        super(helper);
    }

    public RecipeType<ItemUseRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"synergy.jei.itemuse");
    }

    @Nullable
    public IDrawable getIcon() {
        return SimpleIcon.of(this.helper, Items.WOODEN_PICKAXE);
    }

    @Nullable
    public IDrawable getBackground() {
        return this.helper.createDrawable(screenLocations.ITEM_USE, 0, 0, 103, 70);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ItemUseRecipe recipe, IFocusGroup focuses) {
        LiquidBlock fluid;
        Block block;
        builder.addInputSlot(5, 4).addIngredients(recipe.getInputItem());
        try {
            BlockState in = recipe.getInputState();
            block = in.getBlock();
            if (block instanceof LiquidBlock) {
                fluid = (LiquidBlock)block;
                builder.addInputSlot(45, 27).addFluidStack((Fluid)fluid.fluid);
            } else {
                builder.addInputSlot(45, 27).addItemStack(x.item(in));
            }
        }
        catch (Exception in) {
            // empty catch block
        }
        try {
            BlockState out = recipe.getOutputState();
            block = out.getBlock();
            if (block instanceof LiquidBlock) {
                fluid = (LiquidBlock)block;
                builder.addOutputSlot(81, 49).addFluidStack((Fluid)fluid.fluid);
            } else {
                builder.addOutputSlot(81, 49).addItemStack(x.item(out));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void draw(ItemUseRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe.canBeDisabled()) {
            this.helper.drawableBuilder(screenLocations.WARNING, 0, 0, 10, 10).setTextureSize(10, 10).build().draw(guiGraphics, 81, 7);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, ItemUseRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (Pos.of(81, 7).setSize(10, 10).test(mouseX, mouseY)) {
            tooltip.add((FormattedText)Component.translatable((String)"synergy.jei.warning.config"));
        }
    }
}

