/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.compat.jei;

import com.devdyna.synergy.api.datagen.ExtraRecipeProvider;
import com.devdyna.synergy.client.gui.fuel_cell.FuelCellScreen;
import com.devdyna.synergy.compat.jei.categories.CropResultCategory;
import com.devdyna.synergy.compat.jei.categories.DryableBricksCategory;
import com.devdyna.synergy.compat.jei.categories.FluidProviderCategory;
import com.devdyna.synergy.compat.jei.categories.ItemProviderCategory;
import com.devdyna.synergy.compat.jei.categories.ItemUseCategory;
import com.devdyna.synergy.compat.jei.categories.QuernCategory;
import com.devdyna.synergy.compat.jei.categories.ReactorCellCategory;
import com.devdyna.synergy.compat.jei.categories.UrnCategory;
import com.devdyna.synergy.init.types.zBlocks;
import com.devdyna.synergy.init.types.zRecipeTypes;
import com.devdyna.synergy.utils.ClazzUtil;
import com.devdyna.synergy.utils.x;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

@JeiPlugin
public class Plugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return x.rl("synergy", "jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ArrayList toHide = new ArrayList();
        ClazzUtil.getAllzItems().forEach(b -> {
            if (!ExtraRecipeProvider.clearNBT.contains(b.get())) {
                Minecraft.getInstance().level.getRecipeManager().byKey(ResourceLocation.parse((String)(String.valueOf(b.getId()) + "_clear_nbt"))).ifPresent(r -> toHide.add(r));
            }
        });
        jeiRuntime.getRecipeManager().hideRecipes(RecipeTypes.CRAFTING, toHide);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration r) {
        r.addRecipeCatalyst(x.item(zBlocks.REACTOR_CONTROLLER), new RecipeType[]{ReactorCellCategory.TYPE});
        r.addRecipeCatalyst(x.item(zBlocks.REACTOR_FUEL_CELL), new RecipeType[]{ReactorCellCategory.TYPE});
        r.addRecipeCatalyst(x.item(zBlocks.URN), new RecipeType[]{UrnCategory.TYPE});
        r.addRecipeCatalyst(x.item(zBlocks.QUERN), new RecipeType[]{QuernCategory.TYPE});
        r.addRecipeCatalyst(x.item(zBlocks.ITEM_PROVIDER), new RecipeType[]{ItemProviderCategory.TYPE});
        r.addRecipeCatalyst(x.item(zBlocks.FLUID_PROVIDER), new RecipeType[]{FluidProviderCategory.TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration r) {
        IGuiHelper helper = r.getJeiHelpers().getGuiHelper();
        r.addRecipeCategories(new IRecipeCategory[]{new ReactorCellCategory(helper)});
        r.addRecipeCategories(new IRecipeCategory[]{new UrnCategory(helper)});
        r.addRecipeCategories(new IRecipeCategory[]{new CropResultCategory(helper)});
        r.addRecipeCategories(new IRecipeCategory[]{new ItemUseCategory(helper)});
        r.addRecipeCategories(new IRecipeCategory[]{new QuernCategory(helper)});
        r.addRecipeCategories(new IRecipeCategory[]{new ItemProviderCategory(helper)});
        r.addRecipeCategories(new IRecipeCategory[]{new FluidProviderCategory(helper)});
        r.addRecipeCategories(new IRecipeCategory[]{new DryableBricksCategory(helper)});
    }

    public void registerRecipes(IRecipeRegistration r) {
        RecipeManager recipes = Minecraft.getInstance().level.getRecipeManager();
        r.addRecipes(ReactorCellCategory.TYPE, recipes.getAllRecipesFor(zRecipeTypes.FUEL_CELL_RECIPE.getType()).stream().map(RecipeHolder::value).toList());
        r.addRecipes(UrnCategory.TYPE, recipes.getAllRecipesFor(zRecipeTypes.URN_RITUAL_RECIPE.getType()).stream().map(RecipeHolder::value).toList());
        r.addRecipes(CropResultCategory.TYPE, recipes.getAllRecipesFor(zRecipeTypes.CROP_RESULT.getType()).stream().map(RecipeHolder::value).toList());
        r.addRecipes(ItemUseCategory.TYPE, recipes.getAllRecipesFor(zRecipeTypes.ITEM_USE.getType()).stream().map(RecipeHolder::value).toList());
        r.addRecipes(QuernCategory.TYPE, recipes.getAllRecipesFor(zRecipeTypes.QUERN_MILLING.getType()).stream().map(RecipeHolder::value).toList());
        r.addRecipes(ItemProviderCategory.TYPE, recipes.getAllRecipesFor(zRecipeTypes.ITEM_PROVIDER.getType()).stream().map(RecipeHolder::value).toList());
        r.addRecipes(FluidProviderCategory.TYPE, recipes.getAllRecipesFor(zRecipeTypes.FLUID_PROVIDER.getType()).stream().map(RecipeHolder::value).toList());
        r.addRecipes(DryableBricksCategory.TYPE, recipes.getAllRecipesFor(zRecipeTypes.DRYABLE_BRICKS.getType()).stream().map(RecipeHolder::value).toList());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration r) {
        r.addRecipeClickArea(FuelCellScreen.class, 74, 30, 22, 20, new RecipeType[]{ReactorCellCategory.TYPE});
    }
}

