/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.client.gui.fuel_cell;

import com.devdyna.synergy.client.gui.BaseMenu;
import com.devdyna.synergy.init.builder.reactor.cell.FuelCellBE;
import com.devdyna.synergy.init.types.zBlocks;
import com.devdyna.synergy.init.types.zContainer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FuelCellMenu
extends BaseMenu {
    public final FuelCellBE blockEntity;
    private final Level level;
    private final ContainerData data;

    public FuelCellMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public FuelCellMenu(int i, Inventory inv, BlockEntity be, ContainerData data) {
        super((MenuType)zContainer.FUEL_CELL_MENU.get(), i, be);
        this.blockEntity = (FuelCellBE)be;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerSlots(inv);
        this.addMachineSlot(this.blockEntity.getStorage(), 0, 54, 34);
        this.addMachineOutputSlot(this.blockEntity.getStorage(), 1, 104, 34);
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledArrowProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int sizeArrow = 24;
        return maxProgress != 0 && progress != 0 ? progress * sizeArrow / maxProgress : 0;
    }

    @Override
    public Block[] getValidBlock() {
        return new Block[]{(Block)zBlocks.REACTOR_FUEL_CELL.get()};
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }
}

