/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.client.gui;

import com.devdyna.synergy.api.beLogic.ItemStorageBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public abstract class BaseMenu
extends AbstractContainerMenu {
    public int MACHINE_SLOT;

    protected BaseMenu(MenuType<?> menuType, int containerId, BlockEntity blockEntity) {
        super(menuType, containerId);
        if (blockEntity instanceof ItemStorageBlock) {
            ItemStorageBlock be = (ItemStorageBlock)blockEntity;
            this.MACHINE_SLOT = be.MachineSlots();
        } else {
            this.MACHINE_SLOT = 0;
        }
    }

    protected void addPlayerSlots(Inventory inventory) {
        this.addInventory(inventory);
        this.addHotbar(inventory);
    }

    protected void addInventory(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    protected void addHotbar(Inventory inventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
    }

    protected void addMachineSlot(ItemStackHandler beSlot, int id, int x2, int y) {
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)beSlot, id, x2, y));
    }

    protected void addMachineOutputSlot(ItemStackHandler beSlot, int id, int x2, int y) {
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)beSlot, id, x2, y){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
    }

    protected void addMachineSlots(ItemStackHandler beSlot, int baseId, int x2, int y, int count, int xOf, int yOf) {
        for (int i = 0; i < count; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)beSlot, baseId + i, x2 + xOf * i, y + yOf * i));
        }
    }

    protected void addFilteredSlot(ItemStackHandler beSlot, int id, int x2, int y, ItemStack filter) {
        SlotItemHandler a = new SlotItemHandler((IItemHandler)beSlot, id, x2, y);
        a.mayPlace(filter);
        this.addSlot((Slot)a);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.MACHINE_SLOT ? !this.moveItemStackTo(itemstack1, this.MACHINE_SLOT, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.MACHINE_SLOT, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return (Boolean)ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockEntity().getBlockPos()).evaluate((lvl, pos) -> {
            for (Block b : this.getValidBlock()) {
                if (!lvl.getBlockState(pos).is(b)) continue;
                return player.canInteractWithBlock(pos, 4.0);
            }
            return false;
        }, (Object)true);
    }

    public abstract Block[] getValidBlock();

    public abstract BlockEntity getBlockEntity();

    public abstract Level getLevel();
}

