/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api;

import com.devdyna.synergy.init.types.zBlocks;
import com.devdyna.synergy.init.types.zFluids;
import com.devdyna.synergy.init.types.zItems;
import com.devdyna.synergy.utils.x;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;

public class zFluid {
    private int color;
    private String id;
    private DeferredHolder<Fluid, BaseFlowingFluid.Source> fluidsource;
    private DeferredHolder<Fluid, FlowingFluid> fluidflowing;
    private DeferredHolder<Item, BucketItem> itemBucket;
    private DeferredHolder<Block, LiquidBlock> block;
    private BaseFlowingFluid.Properties prop;
    private DeferredHolder<FluidType, ?> type;
    private ResourceLocation still;
    private ResourceLocation flowing;
    private ResourceLocation overlay;
    private int viscosity;
    private boolean canDrown;
    private boolean canSwim;
    private boolean canPushEntity;
    private boolean canConvertToSource;

    public zFluid(String id, float r, float g, float b, float a) {
        this(id, zFluid.rgba(r, g, b, a));
    }

    public zFluid(String id, final int color) {
        this.color = color;
        this.id = id;
        this.still = x.rl("minecraft", "block/water_still");
        this.flowing = x.rl("minecraft", "block/water_flow");
        this.overlay = x.rl("minecraft", "block/water_overlay");
        this.viscosity = 1000;
        this.canDrown = false;
        this.canSwim = false;
        this.canPushEntity = false;
        this.canConvertToSource = false;
        this.type = zFluids.zFluidTypes.register(id + "_type", () -> new FluidType(FluidType.Properties.create().lightLevel(10).viscosity(this.viscosity).canDrown(this.canDrown).canSwim(this.canSwim).canPushEntity(this.canPushEntity).canConvertToSource(this.canConvertToSource).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY)){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> c) {
                c.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return zFluid.this.still;
                    }

                    public int getTintColor(FluidState s, BlockAndTintGetter g, BlockPos p) {
                        return color;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return zFluid.this.flowing;
                    }

                    public ResourceLocation getOverlayTexture() {
                        return zFluid.this.overlay;
                    }

                    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                        return ResourceLocation.parse((String)"textures/misc/underwater.png");
                    }

                    public int getTintColor() {
                        return color;
                    }
                });
                super.initializeClient(c);
            }
        });
        this.prop = new BaseFlowingFluid.Properties(this.type, null, null);
        this.fluidsource = zFluids.zFluids.register(id + "_source", () -> new BaseFlowingFluid.Source(this.prop));
        this.fluidflowing = zFluids.zFluids.register(id + "_flowing", () -> new BaseFlowingFluid.Flowing(this.prop));
        this.itemBucket = zItems.zBucketItems.register(id + "_bucket", () -> new BucketItem((Fluid)this.fluidsource.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
        this.block = zBlocks.zBlockFluids.register(id, () -> new LiquidBlock((FlowingFluid)this.fluidflowing.value(), BlockBehaviour.Properties.of().mapColor(MapColor.WATER).replaceable().noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid().sound(SoundType.EMPTY).liquid().lightLevel(value -> 10).emissiveRendering((s, g, p) -> true)));
        this.prop = new BaseFlowingFluid.Properties(this.type, this.fluidsource, this.fluidflowing).bucket(this.itemBucket).block(this.block);
    }

    public DeferredHolder<Block, LiquidBlock> getBlock() {
        return this.block;
    }

    public DeferredHolder<Fluid, FlowingFluid> getFlowing() {
        return this.fluidflowing;
    }

    public DeferredHolder<Fluid, BaseFlowingFluid.Source> getSource() {
        return this.fluidsource;
    }

    public DeferredHolder<Item, BucketItem> getItemBucket() {
        return this.itemBucket;
    }

    public ResourceLocation getStill() {
        return this.still;
    }

    public DeferredHolder<FluidType, ?> getType() {
        return this.type;
    }

    public zFluid setTextures(ResourceLocation still) {
        this.still = still;
        return this;
    }

    public zFluid setTextures(ResourceLocation still, ResourceLocation flowing) {
        this.flowing = flowing;
        return this.setTextures(still);
    }

    public zFluid setTextures(ResourceLocation still, ResourceLocation flowing, ResourceLocation overlay) {
        this.overlay = overlay;
        return this.setTextures(still, flowing);
    }

    public zFluid setStillTexture(ResourceLocation rl) {
        this.still = rl;
        return this;
    }

    public zFluid setFlowingTexture(ResourceLocation rl) {
        this.flowing = rl;
        return this;
    }

    public zFluid setOverlayTexture(ResourceLocation rl) {
        this.overlay = rl;
        return this;
    }

    public zFluid swim() {
        this.canSwim = true;
        return this;
    }

    public zFluid convertToSource() {
        this.canConvertToSource = true;
        return this;
    }

    public zFluid drown() {
        this.canDrown = true;
        return this;
    }

    public zFluid pushEntity() {
        this.canPushEntity = true;
        return this;
    }

    public zFluid setViscosity(int v) {
        this.viscosity = v;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public String getId() {
        return this.id;
    }

    public static zFluid create(String id, int color) {
        return new zFluid(id, color);
    }

    public static zFluid create(String id, float r, float g, float b, float a) {
        return new zFluid(id, r, g, b, a);
    }

    public static int rgba(float r, float g, float b, float a) {
        return (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }
}

