/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.plants.builder;

import com.devdyna.synergy.api.plants.builder.BaseShortCropBlock;
import com.devdyna.synergy.utils.LevelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class BaseCropMushroom
extends BaseShortCropBlock {
    VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0)};

    protected BaseCropMushroom(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.GRASS));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE_BY_AGE[this.getAge(state)];
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return !this.isMaxAge(state);
    }

    public TagKey<Block> getSpawnFilter() {
        return null;
    }

    protected boolean mayPlaceOn(BlockState s, BlockGetter l, BlockPos p) {
        return s.isSolidRender(l, p);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).is(BlockTags.MUSHROOM_GROW_BLOCK) ? true : (level.getBlockState(pos.below()).canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state).isDefault() ? level.getRawBrightness(pos, 0) < this.maxBrightnessSustainable() && this.mayPlaceOn(level.getBlockState(pos.below()), (BlockGetter)level, pos.below()) && level.getBlockState(pos.below()).is(this.getSpawnFilter()) : level.getBlockState(pos.below()).canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state).isTrue());
    }

    public void spreadSpores(BlockPos pos, Level level, BlockState state) {
        BlockPos valid = this.getSpreadPos(pos, level);
        if (valid != null) {
            level.setBlockAndUpdate(valid, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
        }
    }

    public BlockPos getSpreadPos(BlockPos pos, Level level) {
        if (pos == null) {
            return null;
        }
        Iterable spots = BlockPos.randomBetweenClosed((RandomSource)level.random, (int)6, (int)(pos.getX() - 3), (int)(pos.getY() - 3), (int)(pos.getZ() - 3), (int)(pos.getX() + 3), (int)(pos.getY() + 3), (int)(pos.getZ() + 3));
        if (spots != null) {
            for (BlockPos offpos : spots) {
                if (!level.getBlockState(offpos).is(BlockTags.AIR) || level.getBlockState(offpos).getBlock() instanceof LiquidBlock || !this.canSurvive(level.getBlockState(offpos), (LevelReader)level, pos) || !this.mayPlaceOn(level.getBlockState(offpos.below()), (BlockGetter)level, pos.below()) || level.getRawBrightness(offpos, 0) >= this.maxBrightnessSustainable()) continue;
                return offpos;
            }
        }
        return null;
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(40) == 0 ? 1 : 0) != 0)) {
            level.setBlock(pos, this.getStateForAge(this.getAge(state) + 1), 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
        if (!this.isMaxAge(state) && LevelUtil.chance(2 + this.getMaxAge() - this.getAge(state), (Level)level)) {
            this.spreadSpores(pos, (Level)level, state);
        }
    }

    public int maxBrightnessSustainable() {
        return 13;
    }
}

