/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.plants.builder;

import com.devdyna.synergy.api.harvester.HarvestModes;
import com.devdyna.synergy.api.harvester.PlantHandler;
import com.devdyna.synergy.api.plants.Harvestable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class BaseCropBlock
extends CropBlock
implements Harvestable,
PlantHandler {
    public BaseCropBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.harvestCrop(level, state, pos, player, stack)) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public List<ItemStack> getItemResult(Level level, BlockState state, BlockPos pos, Player player, ItemStack tool) {
        return Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null, (Entity)player, (ItemStack)tool);
    }

    @Override
    public int maxAge() {
        return this.getMaxAge();
    }

    @Override
    public boolean canBeHarvested(BlockState state) {
        return this.isMaxAge(state);
    }

    @Override
    public IntegerProperty getPublicAgeProperty() {
        return this.getAgeProperty();
    }

    @Override
    public List<ItemStack> itemResult(Level level, BlockPos pos) {
        return Block.getDrops((BlockState)level.getBlockState(pos), (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
    }

    @Override
    public void blockReplanted(Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    @Override
    public ArrayList<Block> blockTree() {
        return null;
    }

    @Override
    public HarvestModes getMode() {
        return HarvestModes.BLOCK_REPLANT;
    }

    @Override
    public boolean whenCanBeHarvested(Level level, BlockPos pos) {
        return this.isMaxAge(level.getBlockState(pos));
    }

    @Override
    public IntegerProperty getProperty() {
        return this.getAgeProperty();
    }
}

