/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.plants;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface CropEntityInteraction {
    public static final List<EntityType<?>> EntityTypeSafe = List.of(EntityType.FOX, EntityType.BEE);
    public static final double stuck = (double)0.8f;
    public static final double hurt = (double)0.003f;

    public boolean HurtWhenInside();

    public boolean HurtWhenStep();

    public boolean StuckWhenInside();

    default public boolean stuckCondition(Entity entity) {
        return entity instanceof LivingEntity && !EntityTypeSafe.contains(entity.getType());
    }

    default public boolean hurtCondition(Entity entity, Level level) {
        return !level.isClientSide && (entity.xOld != entity.getX() || entity.zOld != entity.getZ()) && Math.abs(entity.getX() - entity.xOld) >= (double)0.003f || Math.abs(entity.getZ() - entity.zOld) >= (double)0.003f;
    }

    default public Vec3 speedFactor() {
        return new Vec3((double)0.8f, 0.75, (double)0.8f);
    }

    default public void getEntityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.StuckWhenInside()) {
            entity.makeStuckInBlock(state, this.speedFactor());
        }
        if (this.HurtWhenInside()) {
            entity.hurt(level.damageSources().sweetBerryBush(), 1.0f);
        }
    }

    default public void getStepEntityOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (this.HurtWhenStep()) {
            entity.hurt(level.damageSources().sweetBerryBush(), 0.1f);
        }
    }
}

