/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.pipe;

import com.devdyna.synergy.api.pipe.pipeProperties;
import com.devdyna.synergy.init.types.zBlockTag;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;

public interface pipeType {
    public static final EnumProperty<pipeProperties> NORTH = EnumProperty.create((String)"north", pipeProperties.class);
    public static final EnumProperty<pipeProperties> SOUTH = EnumProperty.create((String)"south", pipeProperties.class);
    public static final EnumProperty<pipeProperties> EAST = EnumProperty.create((String)"east", pipeProperties.class);
    public static final EnumProperty<pipeProperties> WEST = EnumProperty.create((String)"west", pipeProperties.class);
    public static final EnumProperty<pipeProperties> UP = EnumProperty.create((String)"up", pipeProperties.class);
    public static final EnumProperty<pipeProperties> DOWN = EnumProperty.create((String)"down", pipeProperties.class);
    public static final VoxelShape BASE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    public static final VoxelShape X_PART = Block.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    public static final VoxelShape Y_PART = Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape Z_PART = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    public static final List<EnumProperty<pipeProperties>> PROPRTIES = List.of(DOWN, UP, NORTH, SOUTH, WEST, EAST);
    public static final List<Integer> X_ROT = List.of(Integer.valueOf(-90), Integer.valueOf(90), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
    public static final List<Integer> Y_ROT = List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(180), Integer.valueOf(-90), Integer.valueOf(90));
    public static final List<Direction> DIRECTIONS = Arrays.stream(Direction.values()).toList();
    public static final pipeProperties[] allTrue = new pipeProperties[]{pipeProperties.TRUE, pipeProperties.NODE};

    public static void PipeStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        PROPRTIES.forEach(e -> b.add(new Property[]{e}));
    }

    public static VoxelShape getPipeBaseShape(BlockState s) {
        VoxelShape model = BASE;
        if (s.getValue(DOWN) == pipeProperties.TRUE) {
            model = Shapes.or((VoxelShape)model, (VoxelShape)VoxelShapes.DOWN);
        }
        if (s.getValue(UP) == pipeProperties.TRUE) {
            model = Shapes.or((VoxelShape)model, (VoxelShape)VoxelShapes.UP);
        }
        if (s.getValue(SOUTH) == pipeProperties.TRUE) {
            model = Shapes.or((VoxelShape)model, (VoxelShape)VoxelShapes.SOUTH);
        }
        if (s.getValue(NORTH) == pipeProperties.TRUE) {
            model = Shapes.or((VoxelShape)model, (VoxelShape)VoxelShapes.NORTH);
        }
        if (s.getValue(EAST) == pipeProperties.TRUE) {
            model = Shapes.or((VoxelShape)model, (VoxelShape)VoxelShapes.EAST);
        }
        if (s.getValue(WEST) == pipeProperties.TRUE) {
            model = Shapes.or((VoxelShape)model, (VoxelShape)VoxelShapes.WEST);
        }
        return model.optimize();
    }

    public static void getPipeMultiPart(Block b, MultiPartBlockStateBuilder model, ModelFile core2, ModelFile pipe) {
        model.part().modelFile(core2).addModel();
        ((MultiPartBlockStateBuilder.PartBuilder)model.part().modelFile(pipe).addModel()).condition(NORTH, (Comparable[])allTrue);
        ((MultiPartBlockStateBuilder.PartBuilder)model.part().modelFile(pipe).rotationY(90).addModel()).condition(EAST, (Comparable[])allTrue);
        ((MultiPartBlockStateBuilder.PartBuilder)model.part().modelFile(pipe).rotationX(180).addModel()).condition(SOUTH, (Comparable[])allTrue);
        ((MultiPartBlockStateBuilder.PartBuilder)model.part().modelFile(pipe).rotationY(270).addModel()).condition(WEST, (Comparable[])allTrue);
        ((MultiPartBlockStateBuilder.PartBuilder)model.part().modelFile(pipe).rotationX(270).addModel()).condition(UP, (Comparable[])allTrue);
        ((MultiPartBlockStateBuilder.PartBuilder)model.part().modelFile(pipe).rotationX(90).addModel()).condition(DOWN, (Comparable[])allTrue);
    }

    @Deprecated
    public static BlockState updatePipeOnPlace(BlockState state, BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        for (Direction face : DIRECTIONS) {
            BlockState offset = level.getBlockState(pos.relative(face));
            if (offset.is(zBlockTag.CAN_CONNECT)) {
                if (offset.getValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face.getOpposite()))) == pipeProperties.NODE) continue;
                level.setBlockAndUpdate(pos.relative(face), (BlockState)offset.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face.getOpposite())), (Comparable)((Object)pipeProperties.TRUE)));
                continue;
            }
            if (level.getBlockEntity(pos.relative(face)) != null) {
                state = (BlockState)state.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face)), (Comparable)((Object)pipeProperties.TRUE));
                continue;
            }
            state = (BlockState)state.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face)), (Comparable)((Object)pipeProperties.FALSE));
        }
        return state;
    }

    public static BlockState updatePipeOnPlace(BlockState state, Level level, BlockPos pos) {
        for (Direction face : DIRECTIONS) {
            BlockState offset = level.getBlockState(pos.relative(face));
            if (offset.is(zBlockTag.CAN_CONNECT)) {
                if (offset.getValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face.getOpposite()))) == pipeProperties.NODE) continue;
                offset = (BlockState)offset.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face.getOpposite())), (Comparable)((Object)pipeProperties.TRUE));
                level.setBlockAndUpdate(pos.relative(face), offset);
                continue;
            }
            if (level.getBlockEntity(pos.relative(face)) != null) {
                state = (BlockState)state.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face)), (Comparable)((Object)pipeProperties.TRUE));
                continue;
            }
            state = (BlockState)state.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face)), (Comparable)((Object)pipeProperties.FALSE));
        }
        return state;
    }

    public static void onDestroyPipe(BlockState state, Level level, BlockPos pos) {
        for (Direction face : DIRECTIONS) {
            BlockState offset = level.getBlockState(pos.relative(face));
            if (!offset.is(zBlockTag.CAN_CONNECT) || offset.getValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face.getOpposite()))) == pipeProperties.NODE) continue;
            level.setBlock(pos.relative(face), (BlockState)offset.setValue((Property)PROPRTIES.get(DIRECTIONS.indexOf(face.getOpposite())), (Comparable)((Object)pipeProperties.FALSE)), 3);
        }
    }

    public static Direction P2D(EnumProperty<pipeProperties> e) {
        return DIRECTIONS.get(PROPRTIES.indexOf(e));
    }

    public static EnumProperty<pipeProperties> D2P(Direction d) {
        return PROPRTIES.get(DIRECTIONS.indexOf(d));
    }

    public static class VoxelShapes {
        public static VoxelShape DOWN = Y_PART.move(0.0, -0.625, 0.0);
        public static VoxelShape UP = Y_PART;
        public static VoxelShape NORTH = Z_PART;
        public static VoxelShape SOUTH = Z_PART.move(0.0, 0.0, 0.625);
        public static VoxelShape WEST = X_PART;
        public static VoxelShape EAST = X_PART.move(0.625, 0.0, 0.0);
    }
}

