/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.node.builder;

import com.devdyna.synergy.api.node.nodeType;
import com.devdyna.synergy.api.pipe.pipeProperties;
import com.devdyna.synergy.api.pipe.pipeType;
import com.devdyna.synergy.init.types.zBlockTag;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public abstract class NodeBaseBE
extends BlockEntity {
    private Set<BlockPos> failedRoutes;
    private BlockPos input;
    private BlockPos output;

    public NodeBaseBE(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public NodeBaseBE(BlockPos pos, BlockState blockState) {
        super(null, pos, blockState);
    }

    public void tickServer() {
        this.failedRoutes = new HashSet<BlockPos>();
        BlockPos input = this.getInputPos(this.getBlockState(), this.level, this.getBlockPos());
        if (input == null) {
            return;
        }
        this.input = input;
        this.failedRoutes.add(input);
        BlockPos output = this.getOutputPos(this.level, this.getBlockPos());
        if (output == null) {
            return;
        }
        this.output = output;
        BlockState inState = this.level.getBlockState(input);
        BlockState outState = this.level.getBlockState(output);
        BlockEntity inBE = this.level.getBlockEntity(input);
        BlockEntity outBE = this.level.getBlockEntity(output);
        Object inCap = this.getCapType().getCapability(this.level, input, inState, inBE, null);
        Object outCap = this.getCapType().getCapability(this.level, output, outState, outBE, null);
        BlockCapability<?, Direction> capType = this.getCapType();
        if (capType == Capabilities.ItemHandler.BLOCK) {
            this.executeItem((IItemHandler)inCap, (IItemHandler)outCap);
        } else if (capType == Capabilities.EnergyStorage.BLOCK) {
            this.executeEnergy((IEnergyStorage)inCap, (IEnergyStorage)outCap);
        } else if (capType == Capabilities.FluidHandler.BLOCK) {
            this.executeFluid((IFluidHandler)inCap, (IFluidHandler)outCap);
        }
        this.failedRoutes.removeAll(this.failedRoutes);
        this.input = null;
        this.output = null;
    }

    public BlockPos getInputPos() {
        return this.input;
    }

    public BlockPos getOutputPos() {
        return this.output;
    }

    public boolean allowInputNull() {
        return false;
    }

    public void excludePos(BlockPos pos) {
        if (pos != null) {
            this.failedRoutes.add(pos);
        }
    }

    public void excludePos() {
        this.excludePos(this.defineOutput());
    }

    protected void executeItem(@Nullable IItemHandler input, @Nullable IItemHandler output) {
    }

    protected void executeEnergy(@Nullable IEnergyStorage input, @Nullable IEnergyStorage output) {
    }

    protected void executeFluid(@Nullable IFluidHandler input, @Nullable IFluidHandler output) {
    }

    public abstract BlockCapability<?, Direction> getCapType();

    public boolean match(Level level, BlockPos currentPos, BlockState currentState, Direction dir, BlockPos nextPos, BlockState nextState) {
        IFluidHandler handler;
        Object fluid;
        IEnergyStorage storage;
        Object energy;
        BlockCapability<?, Direction> capType = this.getCapType();
        BlockEntity blockEntity = level.getBlockEntity(nextPos);
        if (capType == Capabilities.ItemHandler.BLOCK) {
            Object itemHandler = capType.getCapability(level, nextPos, nextState, blockEntity, (Object)dir);
            if (itemHandler instanceof IItemHandler) {
                IItemHandler handler2 = (IItemHandler)itemHandler;
                for (int slot = 0; slot < handler2.getSlots(); ++slot) {
                    if (!handler2.insertItem(slot, new ItemStack((ItemLike)Items.STONE, 1), true).isEmpty()) continue;
                    return true;
                }
            }
        } else if (capType == Capabilities.EnergyStorage.BLOCK ? (energy = capType.getCapability(level, nextPos, nextState, blockEntity, (Object)dir)) instanceof IEnergyStorage && (storage = (IEnergyStorage)energy).receiveEnergy(1, true) > 0 : capType == Capabilities.FluidHandler.BLOCK && (fluid = capType.getCapability(level, nextPos, nextState, blockEntity, (Object)dir)) instanceof IFluidHandler && (handler = (IFluidHandler)fluid).fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.SIMULATE) > 0) {
            return true;
        }
        return false;
    }

    public void tickClient() {
    }

    public void tickBoth() {
    }

    @Nullable
    private BlockPos getOutputPos(Level level, BlockPos start) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(start);
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            if (this.failedRoutes.contains(current)) continue;
            visited.add(current);
            BlockState state = level.getBlockState(current);
            for (Direction dir : Direction.values()) {
                BlockPos next = current.relative(dir);
                if (visited.contains(next) || state.getValue(pipeType.D2P(dir)) != pipeProperties.TRUE) continue;
                BlockState neighbor = level.getBlockState(next);
                if (this.match(level, current, state, dir, next, neighbor)) {
                    return next;
                }
                if (!neighbor.is(zBlockTag.CAN_CONNECT)) continue;
                queue.add(next);
            }
        }
        this.failedRoutes.add(start);
        return null;
    }

    @Nullable
    private BlockPos getInputPos(BlockState state, Level level, BlockPos nodePos) {
        return nodePos.relative((Direction)state.getValue((Property)nodeType.FACING));
    }

    protected boolean check(BlockPos pos, BlockState state) {
        boolean cond = this.level.getBlockState(pos).is(state.getBlock());
        if (!state.getFluidState().isEmpty()) {
            cond &= state.getFluidState().isSource();
        }
        return cond;
    }

    public static boolean check(Level level, BlockPos pos, BlockState state) {
        boolean cond = level.getBlockState(pos).is(state.getBlock());
        if (!state.getFluidState().isEmpty()) {
            cond &= state.getFluidState().isSource();
        }
        return cond;
    }

    public abstract BlockPos defineOutput();

    public void moveItems(IItemHandler input, IItemHandler output, int maxCount) {
        if (input == null || output == null) {
            return;
        }
        int remaining = maxCount;
        for (int inSlot = 0; inSlot < input.getSlots() && remaining > 0; ++inSlot) {
            int extractAmount;
            ItemStack extracted;
            ItemStack inStack = input.getStackInSlot(inSlot);
            if (inStack.isEmpty() || (extracted = input.extractItem(inSlot, extractAmount = Math.min(inStack.getCount(), remaining), false)).isEmpty()) continue;
            ItemStack leftover = extracted.copy();
            for (int outSlot = 0; outSlot < output.getSlots() && !leftover.isEmpty(); ++outSlot) {
                leftover = output.insertItem(outSlot, leftover, false);
            }
            int inserted = extracted.getCount() - leftover.getCount();
            remaining -= inserted;
            if (leftover.isEmpty()) continue;
            input.insertItem(inSlot, leftover, false);
        }
    }

    protected void moveFluids(IFluidHandler input, IFluidHandler output, int rate) {
        if (input == null || output == null) {
            return;
        }
        FluidUtil.tryFluidTransfer((IFluidHandler)output, (IFluidHandler)input, (int)rate, (boolean)true);
    }

    public static ItemStack insertItemStacked(IItemHandler handler, ItemStack stack, boolean simOn) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simOn);
    }

    public static FluidStack insertFluidStacked(IFluidHandler handler, FluidStack stack, Boolean simOn) {
        if (handler != null) {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack tank = handler.getFluidInTank(i);
                int diff = tank.getAmount();
                int max = handler.getTankCapacity(i);
                if (FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)tank) && max > diff) {
                    tank.setAmount(Math.min(max, diff + stack.getAmount()));
                    stack.setAmount(Math.min(max - diff, stack.getAmount()));
                    return stack;
                }
                if (!tank.isEmpty()) continue;
                stack.setAmount(handler.fill(stack, simOn != false ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
                return FluidStack.EMPTY;
            }
        }
        return stack;
    }

    protected void moveEnergy(IEnergyStorage input, IEnergyStorage output, int maxEnergy) {
        if (input == null || output == null) {
            return;
        }
        int remaining = maxEnergy;
        int extracted = input.extractEnergy(remaining, false);
        if (extracted <= 0) {
            return;
        }
        int accepted = output.receiveEnergy(extracted, false);
        int leftover = extracted - accepted;
        if (leftover > 0) {
            input.receiveEnergy(leftover, false);
        }
    }
}

