/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.node;

import com.devdyna.synergy.api.node.BaseProviderRecipe;
import com.devdyna.synergy.api.node.builder.NodeBaseBE;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface IProvider<I extends RecipeInput, T extends Recipe<I>, L> {
    public Optional<RecipeHolder<T>> getRecipe(BlockPos var1);

    public BlockPos getInput();

    default public boolean isValidSet(BlockState state, Direction dir, BlockPos pos, Level level) {
        boolean requireRight;
        if (level == null) {
            return false;
        }
        Optional<RecipeHolder<T>> r = this.getRecipe(pos);
        if (r == null || r.isEmpty()) {
            return false;
        }
        BaseProviderRecipe recipe = (BaseProviderRecipe)r.get().value();
        boolean requireBelow = recipe.getBelow() != null && !recipe.getBelow().isAir();
        boolean requireLeft = recipe.getLeft() != null && !recipe.getLeft().isAir();
        boolean bl = requireRight = recipe.getRight() != null && !recipe.getRight().isAir();
        if (requireBelow && !NodeBaseBE.check(level, this.getInput().relative(dir), recipe.getBelow())) {
            return false;
        }
        List<Direction> dirs = Arrays.asList(Direction.values()).stream().filter(d -> !d.equals((Object)dir) && !d.equals((Object)dir.getOpposite())).toList();
        BlockPos rightPos = null;
        BlockPos leftPos = null;
        if (requireLeft || requireRight) {
            for (Direction direction : dirs) {
                if (requireRight && NodeBaseBE.check(level, pos.relative(direction), recipe.getRight()) && !pos.relative(direction).equals(leftPos) && rightPos == null) {
                    rightPos = pos.relative(direction);
                    continue;
                }
                if (!requireLeft || !NodeBaseBE.check(level, pos.relative(direction), recipe.getLeft()) || pos.relative(direction).equals(rightPos) || leftPos != null) continue;
                leftPos = pos.relative(direction);
            }
        }
        if (requireLeft && leftPos == null) {
            return false;
        }
        return !requireRight || rightPos != null;
    }
}

