/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.harvester;

import com.devdyna.synergy.api.harvester.PlantHandler;
import com.devdyna.synergy.init.types.zBlockTag;
import com.devdyna.synergy.utils.LevelUtil;
import com.devdyna.synergy.utils.LogUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class VanillaPlants {
    static int treeHarvestingBlockLimit = 2048;
    public static List<IntegerProperty> allCropProperties = List.of(BlockStateProperties.AGE_1, BlockStateProperties.AGE_15, BlockStateProperties.AGE_2, BlockStateProperties.AGE_25, BlockStateProperties.AGE_3, BlockStateProperties.AGE_4, BlockStateProperties.AGE_5, BlockStateProperties.AGE_7);

    public static List<List<Integer>> getTreeDirections() {
        ArrayList<List<Integer>> coordinates = new ArrayList<List<Integer>>();
        for (int x2 = -1; x2 <= 1; ++x2) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x2 == 0 && y == 0 && z == 0) continue;
                    coordinates.add(List.of(Integer.valueOf(x2), Integer.valueOf(y), Integer.valueOf(z)));
                }
            }
        }
        return coordinates;
    }

    public static List<ItemStack> checkReplant(Level level, BlockPos pos) {
        CropBlock crop;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof CropBlock && (crop = (CropBlock)block).isMaxAge(state)) {
            if (crop instanceof PlantHandler) {
                PlantHandler handler = (PlantHandler)crop;
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)handler.getProperty(), (Comparable)Integer.valueOf(0)));
                return Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
            }
            try {
                if (block instanceof BeetrootBlock) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BeetrootBlock.AGE, (Comparable)Integer.valueOf(0)));
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CropBlock.AGE, (Comparable)Integer.valueOf(0)));
                }
                return Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
            }
            catch (Exception e1) {
                for (IntegerProperty p : allCropProperties) {
                    if (!state.hasProperty((Property)p)) continue;
                    try {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)p, (Comparable)Integer.valueOf(0)));
                        return Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
                    }
                    catch (Exception exception) {
                    }
                }
                LogUtil.error("Unsupported crop at : " + pos.toString() + " id: " + block.getDescriptionId() + "\n Report it to Synergy Issue tracker!");
                LevelUtil.addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, (ServerLevel)level, pos.above(), false);
            }
        }
        if (block instanceof NetherWartBlock && (Integer)state.getValue((Property)BlockStateProperties.AGE_3) == 3) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0)));
            return Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
        }
        if (block instanceof SweetBerryBushBlock && (Integer)state.getValue((Property)BlockStateProperties.AGE_3) > 1) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(1)));
            return Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
        }
        if (block instanceof CocoaBlock && (Integer)state.getValue((Property)BlockStateProperties.AGE_2) == 2) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf(0)));
            return Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
        }
        return null;
    }

    public static List<ItemStack> checkNoReplant(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof PumpkinBlock || state.is(Blocks.MELON)) {
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            return Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
        }
        return null;
    }

    public static List<ItemStack> checkTree(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        boolean canProcede = false;
        if (state.is(zBlockTag.HARVESTER_TREE_BREAK)) {
            for (Direction dir : Direction.values()) {
                if (!level.getBlockState(pos.relative(dir)).is(zBlockTag.HARVESTER_TREE_BREAK)) continue;
                canProcede = true;
                break;
            }
        }
        if (canProcede) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            queue.add(pos);
            visited.add(pos);
            int checkBlocks = 0;
            while (!queue.isEmpty()) {
                BlockPos currentPos = (BlockPos)queue.poll();
                for (List<Integer> off : VanillaPlants.getTreeDirections()) {
                    BlockPos adjacentPos = currentPos.offset(off.get(0).intValue(), off.get(1).intValue(), off.get(2).intValue());
                    BlockState adjacentState = level.getBlockState(adjacentPos);
                    if (!adjacentState.is(zBlockTag.HARVESTER_TREE_BREAK) || visited.contains(adjacentPos)) continue;
                    queue.add(adjacentPos);
                    visited.add(adjacentPos);
                    level.setBlockAndUpdate(adjacentPos, Blocks.AIR.defaultBlockState());
                    Block.getDrops((BlockState)adjacentState, (ServerLevel)((ServerLevel)level), (BlockPos)adjacentPos, null).forEach(t -> itemList.add((ItemStack)t));
                }
                if (++checkBlocks < treeHarvestingBlockLimit) continue;
                break;
            }
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null).forEach(t -> itemList.add((ItemStack)t));
            return itemList;
        }
        return null;
    }

    public static List<ItemStack> checkBigPlant(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof CactusBlock || block instanceof SugarCaneBlock || block instanceof BambooStalkBlock) {
            BlockPos tempPos = pos;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            while (level.getBlockState(tempPos.above()).is(block)) {
                tempPos = tempPos.above();
                level.setBlockAndUpdate(tempPos, Blocks.AIR.defaultBlockState());
                Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null).forEach(t -> list.add((ItemStack)t));
            }
            return list;
        }
        return null;
    }
}

