/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.harvester;

import com.devdyna.synergy.api.harvester.HarvestModes;
import com.devdyna.synergy.api.harvester.VanillaPlants;
import com.devdyna.synergy.utils.LogUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;

public interface PlantHandler {
    public static final int treeHarvestingBlockLimit = 2048;

    public List<ItemStack> itemResult(Level var1, BlockPos var2);

    public void blockReplanted(Level var1, BlockPos var2);

    public ArrayList<Block> blockTree();

    public IntegerProperty getProperty();

    public HarvestModes getMode();

    public boolean whenCanBeHarvested(Level var1, BlockPos var2);

    default public List<ItemStack> execute(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        switch (this.getMode()) {
            case BLOCK_NO_REPLANT: {
                if (!this.whenCanBeHarvested(level, pos)) break;
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                return this.itemResult(level, pos);
            }
            case BLOCK_REPLANT: {
                if (!this.whenCanBeHarvested(level, pos)) break;
                this.blockReplanted(level, pos);
                return this.itemResult(level, pos);
            }
            case TREE: {
                if (!this.whenCanBeHarvested(level, pos)) break;
                return this.checkTree(level, pos);
            }
            case BIG_PLANT: {
                if (!this.whenCanBeHarvested(level, pos)) break;
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                while (level.getBlockState(pos.above()).is(block)) {
                    pos = pos.above();
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    this.itemResult(level, pos).forEach(t -> list.add((ItemStack)t));
                }
                return list;
            }
            default: {
                LogUtil.error("UNKNOWN HARVEST MODE");
            }
        }
        return null;
    }

    private List<ItemStack> checkTree(Level level, BlockPos pos) {
        if (this.blockTree() == null || this.blockTree().isEmpty()) {
            LogUtil.error("UNKNOWN TREE BLOCKS");
            return null;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        boolean canProcede = false;
        if (this.blockTree().contains(block)) {
            for (Direction dir : Direction.values()) {
                if (!this.blockTree().contains(level.getBlockState(pos.relative(dir)).getBlock())) continue;
                canProcede = true;
                break;
            }
        }
        if (canProcede) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            queue.add(pos);
            visited.add(pos);
            int checkBlocks = 0;
            while (!queue.isEmpty()) {
                BlockPos currentPos = (BlockPos)queue.poll();
                for (List<Integer> off : VanillaPlants.getTreeDirections()) {
                    BlockPos adjacentPos = currentPos.offset(off.get(0).intValue(), off.get(1).intValue(), off.get(2).intValue());
                    BlockState adjacentState = level.getBlockState(adjacentPos);
                    if (!this.blockTree().contains(adjacentState.getBlock()) || visited.contains(adjacentPos)) continue;
                    queue.add(adjacentPos);
                    visited.add(adjacentPos);
                    level.setBlockAndUpdate(adjacentPos, Blocks.AIR.defaultBlockState());
                    Block.getDrops((BlockState)adjacentState, (ServerLevel)((ServerLevel)level), (BlockPos)adjacentPos, null).forEach(t -> itemList.add((ItemStack)t));
                }
                if (++checkBlocks < 2048) continue;
                break;
            }
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null).forEach(t -> itemList.add((ItemStack)t));
            return itemList;
        }
        return null;
    }
}

