/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.datagen;

import com.devdyna.synergy.api.zFluid;
import com.devdyna.synergy.init.builder.tools.Croock;
import com.devdyna.synergy.init.recipeTypes.builders.CropResultBuilder;
import com.devdyna.synergy.init.recipeTypes.builders.DryableBricksBuilder;
import com.devdyna.synergy.init.recipeTypes.builders.QuernMillingBuilder;
import com.devdyna.synergy.init.recipeTypes.builders.ReactorCellBuilder;
import com.devdyna.synergy.init.recipeTypes.builders.UrnRitualBuilder;
import com.devdyna.synergy.init.types.zBlocks;
import com.devdyna.synergy.init.types.zFluids;
import com.devdyna.synergy.init.types.zItemTag;
import com.devdyna.synergy.init.types.zItems;
import com.devdyna.synergy.utils.x;
import com.devdyna.synergy.zStatic;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class ExtraRecipeProvider
extends RecipeProvider {
    public static List<DeferredHolder<Item, Item>> clearNBT = List.of(zItems.RED_BATTERY, zItems.BLUE_BATTERY, zItems.GREEN_BATTERY);

    public ExtraRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void compatIngotsAndDusts(RecipeOutput c) {
        this.raw_dust_smelt(c, x.rl("c", "raw_materials/tin"), (ItemLike)zItems.TIN_DUST.get(), (ItemLike)zItems.TIN_INGOT.get(), x.rl("c", "ingots/tin"));
        this.raw_dust_smelt(c, x.rl("c", "raw_materials/silver"), (ItemLike)zItems.SILVER_DUST.get(), (ItemLike)zItems.SILVER_INGOT.get(), x.rl("c", "ingots/silver"));
        this.raw_dust_smelt(c, x.rl("c", "raw_materials/nickel"), (ItemLike)zItems.NICKEL_DUST.get(), (ItemLike)zItems.NICKEL_INGOT.get(), x.rl("c", "ingots/nickel"));
        this.raw_dust_smelt(c, x.rl("c", "raw_materials/iridium"), (ItemLike)zItems.IRIDIUM_DUST.get(), (ItemLike)zItems.IRIDIUM_INGOT.get(), x.rl("c", "ingots/iridium"));
        this.raw_dust_smelt(c, x.rl("c", "raw_materials/uranium"), (ItemLike)zItems.URANIUM_DUST.get(), (ItemLike)zItems.URANIUM_INGOT.get(), x.rl("c", "ingots/uranium"));
        this.raw_dust_smelt(c, x.rl("c", "raw_materials/platinum"), (ItemLike)zItems.PLATINUM_DUST.get(), (ItemLike)zItems.PLATINUM_INGOT.get(), x.rl("c", "ingots/platinum"));
        this.raw_dust_smelt(c, x.rl("c", "raw_materials/osmium"), (ItemLike)zItems.OSMIUM_DUST.get(), (ItemLike)zItems.OSMIUM_INGOT.get(), x.rl("c", "ingots/osmium"));
        this.raw_dust_smelt(c, x.rl("c", "raw_materials/aluminum"), (ItemLike)zItems.ALUMINUM_DUST.get(), (ItemLike)zItems.ALUMINUM_INGOT.get(), x.rl("c", "ingots/aluminum"));
        this.raw_dust_smelt(c, x.rl("c", "raw_materials/lead"), (ItemLike)zItems.LEAD_DUST.get(), (ItemLike)zItems.LEAD_INGOT.get(), x.rl("c", "ingots/lead"));
    }

    protected void nuggetIngotBlock(RecipeOutput c, ItemLike nugget, ItemLike ingot, ItemLike block) {
        ExtraRecipeProvider.packUnpack(c, nugget, ingot, false);
        ExtraRecipeProvider.packUnpack(c, ingot, block, false);
    }

    protected void raw_dust_smelt(RecipeOutput c, ItemLike raw, ItemLike dust, ItemLike ingot) {
        QuernMillingBuilder.of().input(x.ingredient(raw.asItem())).output(x.item(dust.asItem(), 3)).unlockedBy().save(c, "_from_raw");
        QuernMillingBuilder.of().input(x.ingredient(ingot.asItem())).output(x.item((ItemLike)dust.asItem())).unlockedBy().save(c, "_from_ingot");
        this.doubleSmelt(c, dust, ingot);
    }

    protected void raw_dust_smelt(RecipeOutput c, ResourceLocation raw, ItemLike dust, ItemLike ingot) {
        QuernMillingBuilder.of().input(x.ingredient(raw)).output(x.item(dust.asItem(), 3)).unlockedBy().save(c.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(raw))}), "_from_raw");
        QuernMillingBuilder.of().input(x.ingredient(ingot.asItem())).output(x.item((ItemLike)dust.asItem())).unlockedBy().save(c, "_from_ingot");
        this.doubleSmelt(c, dust, ingot);
    }

    protected void raw_dust_smelt(RecipeOutput c, ResourceLocation raw, ItemLike dust, ItemLike ingot, ResourceLocation ingotTag) {
        QuernMillingBuilder.of().input(x.ingredient(raw)).output(x.item(dust.asItem(), 3)).unlockedBy().save(c.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(raw))}), "_from_raw");
        QuernMillingBuilder.of().input(x.ingredient(ingotTag)).output(x.item((ItemLike)dust.asItem())).unlockedBy().save(c.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(ingotTag))}), "_from_ingot");
        this.doubleSmelt(c, dust, ingot);
    }

    protected void doubleSmelt(RecipeOutput c, ItemLike input, ItemLike output) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)x.ingredient(input.asItem()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output.asItem(), (float)0.1f, (int)100).unlockedBy(ExtraRecipeProvider.getHasName((ItemLike)input), ExtraRecipeProvider.has((ItemLike)output)).save(c, "synergy:" + x.path(output.asItem()) + "_from_" + x.path(input.asItem()) + "_blasting");
        SimpleCookingRecipeBuilder.smelting((Ingredient)x.ingredient(input.asItem()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output.asItem(), (float)0.1f, (int)200).unlockedBy(ExtraRecipeProvider.getHasName((ItemLike)input), ExtraRecipeProvider.has((ItemLike)output)).save(c, "synergy:" + x.path(output.asItem()) + "_from_" + x.path(input.asItem()) + "_smelting");
    }

    protected static void unpacker(RecipeOutput c, ItemLike input, ItemLike output, int count) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).requires(input).group("synergy").unlockedBy(ExtraRecipeProvider.getHasName((ItemLike)input), ExtraRecipeProvider.has((ItemLike)input)).save(c, ExtraRecipeProvider.getConversionRecipeName((ItemLike)output, (ItemLike)input));
    }

    protected static void brickRecipes(RecipeOutput c) {
        DryableBricksBuilder.of().input(Items.CLAY_BALL).block((Block)zBlocks.CLAY_BRICK.get()).output(Items.BRICK).unlockedBy().group("synergy").save(c);
        DryableBricksBuilder.of().input(zItems.PACKED_MUD_BALL).block((Block)zBlocks.PACKED_MUD_BRICK.get()).output(zItems.PACKED_MUD_BRICK).unlockedBy().group("synergy").save(c);
    }

    protected static void twoByTwoPacker(RecipeOutput c, ItemLike output, TagKey<Item> tag) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).define(Character.valueOf('#'), tag).pattern("##").pattern("##").unlockedBy("synergy", ExtraRecipeProvider.has(tag)).save(c);
    }

    protected void plate(Item input, Item output, RecipeOutput c) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)3).pattern("III").define(Character.valueOf('I'), (ItemLike)input).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)input)).group("synergy").save(c);
    }

    protected void nodeRecipe(RecipeOutput c, Block b, ItemLike catalyst) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)b.asItem()).pattern(" P ").pattern("RBR").pattern("SCS").define(Character.valueOf('P'), (ItemLike)((Block)zBlocks.PIPE.get()).asItem()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('C'), catalyst).define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_REDSTONE).define(Character.valueOf('S'), Tags.Items.STONES).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zBlocks.PIPE.get()))).group(zStatic.PipeStuff.types.item_node).save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)b.asItem(), (int)4).pattern(" P ").pattern("RBR").pattern("SCS").define(Character.valueOf('P'), (ItemLike)((Block)zBlocks.PIPE.get()).asItem()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('C'), catalyst).define(Character.valueOf('B'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('S'), Tags.Items.STONES).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zBlocks.PIPE.get()))).group(zStatic.PipeStuff.types.item_node).save(c, String.valueOf(BuiltInRegistries.ITEM.getKey((Object)b.asItem())) + "_alt");
    }

    protected void node_alt(RecipeOutput c, ItemLike input, ItemLike output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).requires(input).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)input)).group(zStatic.PipeStuff.types.item_node).save(c, String.valueOf(BuiltInRegistries.ITEM.getKey((Object)input.asItem())) + "_alt2");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)input).requires(output).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)output)).group(zStatic.PipeStuff.types.item_node).save(c, String.valueOf(BuiltInRegistries.ITEM.getKey((Object)output.asItem())) + "_alt2");
    }

    protected void cropResultRecipes(RecipeOutput c) {
        List<Ingredient> seeds = List.of(x.ingredient(zItemTag.RICE_PLANT), x.ingredient(((Block)zBlocks.AZALEA.get()).asItem()), x.ingredient(zItemTag.COTTON_PLANT), x.ingredient(zItemTag.CAVE_WHEAT_PLANT), x.ingredient((Item)zItems.BLUE_CUP_SPORE.get()), x.ingredient((Item)zItems.VIOLET_WEBCAP_SPORE.get()));
        List<List<Item>> result = List.of(List.of((Item)zItems.RICE_SEED.get()), List.of((Item)zItems.AZALEA_SEEDS.get(), (Item)zItems.SMALL_AZALEA_LEAF.get(), (Item)zItems.SMALL_AZALEA_ROOTS.get()), List.of((Item)zItems.COTTON_SEEDS.get(), (Item)zItems.COTTON.get()), List.of((Item)zItems.CAVE_WHEAT_SEEDS.get(), Items.WHEAT), List.of((Item)zItems.BLUE_CUP_SPORE.get(), (Item)zItems.BLUE_CUP_MUSHROOM.get()), List.of((Item)zItems.VIOLET_WEBCAP_SPORE.get(), (Item)zItems.VIOLET_WEBCAP_MUSHROOM.get()));
        seeds.forEach(s -> CropResultBuilder.of().input((Ingredient)s).output(((List)result.get(seeds.indexOf(s))).stream().map(i -> x.item((ItemLike)i)).toList()).group("synergy").unlockedBy().save(c));
    }

    protected void clearNBT(RecipeOutput c) {
        clearNBT.forEach(i -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)i.get())).requires((ItemLike)i.get()).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)i.get()))).group("synergy").save(c, i.getRegisteredName() + "_clear_nbt"));
    }

    protected void coolerRecipes(RecipeOutput c) {
        List<DeferredHolder> coolers = List.of(zBlocks.COPPER_COOLER, zBlocks.GOLD_COOLER, zBlocks.IRON_COOLER, zBlocks.ENDER_COOLER, zBlocks.FROST_COOLER, zBlocks.LAPIS_COOLER, zBlocks.SCULK_COOLER, zBlocks.WATER_COOLER, zBlocks.QUARTZ_COOLER, zBlocks.SHADOW_COOLER, zBlocks.DIAMOND_COOLER, zBlocks.EMERALD_COOLER, zBlocks.REDSTONE_COOLER, zBlocks.GLOWSTONE_COOLER, zBlocks.NETHERITE_COOLER);
        List<Item> ingredients = List.of(Items.COPPER_INGOT, Items.GOLD_INGOT, Items.IRON_INGOT, Items.ENDER_PEARL, Items.PACKED_ICE, Items.LAPIS_LAZULI, Items.SCULK, Items.WATER_BUCKET, Items.QUARTZ, (Item)zItems.GHOUL_HEART.get(), Items.DIAMOND, Items.EMERALD, Items.REDSTONE, Items.GLOWSTONE, Items.NETHERITE_INGOT);
        for (DeferredHolder b : coolers) {
            int index = coolers.indexOf(b);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)b.get())).requires((ItemLike)ingredients.get(index)).requires((ItemLike)zBlocks.COOLER_BASE.get()).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)ingredients.get(index)))).save(c);
        }
    }

    protected void bacteries(RecipeOutput c) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.RED_BATTERY.get())).pattern(" R ").pattern("RHR").pattern(" R ").define(Character.valueOf('R'), zItemTag.URN_MIXTURES).define(Character.valueOf('H'), (ItemLike)zItems.BLUE_BATTERY.get()).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zItems.BLUE_BATTERY.get()))).group("synergy").save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.BLUE_BATTERY.get())).pattern(" R ").pattern("RHR").pattern(" R ").define(Character.valueOf('R'), zItemTag.GEMS_AQUAMARINE).define(Character.valueOf('H'), (ItemLike)zItems.GREEN_BATTERY.get()).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zItems.AQUAMARINE.get()))).group("synergy").save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.GREEN_BATTERY.get())).pattern(" S ").pattern("RHR").pattern(" R ").define(Character.valueOf('S'), (ItemLike)Items.REDSTONE).define(Character.valueOf('R'), (ItemLike)Items.SLIME_BALL).define(Character.valueOf('H'), (ItemLike)zItems.CONDENSER.get()).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zItems.CONDENSER.get()))).group("synergy").save(c);
    }

    protected void legacyItemComponents(RecipeOutput c) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.RESISTOR.get()), (int)4).pattern(" MN").pattern("MGM").pattern("NM ").define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('M'), (ItemLike)zItems.GUARDIAN_SCALE.get()).define(Character.valueOf('G'), (ItemLike)zItems.BONE_MEAL_MIXTURE.get()).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zItems.BONE_MEAL_MIXTURE.get()))).group("synergy").save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.RESISTOR.get()), (int)8).pattern(" MN").pattern("MGM").pattern("NM ").define(Character.valueOf('N'), zItemTag.NUGGET_STEEL).define(Character.valueOf('M'), zItemTag.GEMS_AQUAMARINE).define(Character.valueOf('G'), zItemTag.URN_MIXTURES).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zItems.STEEL_NUGGET.get()))).group("synergy").save(c, "synergy:" + x.path((Item)zItems.RESISTOR.get()) + "_improved");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.CHIP.get()), (int)4).pattern(" N ").pattern(" GN").pattern("Q  ").define(Character.valueOf('G'), (ItemLike)zItems.BONE_MEAL_MIXTURE.get()).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zItems.BONE_MEAL_MIXTURE.get()))).group("synergy").save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.CHIP.get()), (int)8).pattern(" N ").pattern(" GN").pattern("Q  ").define(Character.valueOf('G'), zItemTag.URN_MIXTURES).define(Character.valueOf('N'), zItemTag.NUGGET_STEEL).define(Character.valueOf('Q'), zItemTag.DUST_QUARTZ).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zItems.BONE_MEAL_MIXTURE.get()))).group("synergy").save(c, "synergy:" + x.path((Item)zItems.CHIP.get()) + "_improved");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.CONDENSER.get()), (int)4).pattern("N N").pattern("GMG").pattern(" I ").define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('G'), (ItemLike)zItems.BONE_MEAL_MIXTURE.get()).define(Character.valueOf('M'), (ItemLike)zItems.VIOLET_WEBCAP_MUSHROOM.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zItems.BONE_MEAL_MIXTURE.get()))).group("synergy").save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.CONDENSER.get()), (int)8).pattern("N N").pattern("GMG").pattern(" I ").define(Character.valueOf('N'), zItemTag.NUGGET_STEEL).define(Character.valueOf('G'), zItemTag.URN_MIXTURES).define(Character.valueOf('M'), zItemTag.GEMS_SILICON).define(Character.valueOf('I'), zItemTag.INGOT_STEEL).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zItems.SILICON.get()))).group("synergy").save(c, "synergy:" + x.path((Item)zItems.CONDENSER.get()) + "_improved");
    }

    protected void fuelCellNuclearReactions(RecipeOutput c) {
        UrnRitualBuilder.of().add(zItems.WASTE).output(zItems.URANIUM).group("synergy").unlockedBy().save(c);
        UrnRitualBuilder.of().add(zItemTag.URANIUM).add(zItemTag.DUST_COAL).output(zItems.THORIUM, 2).unlockedBy().save(c);
        UrnRitualBuilder.of().add(zItemTag.THORIUM).add(zItemTag.DUST_DIAMOND).add(zItemTag.DUST_QUARTZ).output(zItems.PLUTONIUM, 2).unlockedBy().save(c);
        UrnRitualBuilder.of().add(zItemTag.PLUTONIUM).add(zItemTag.DUST_LAPIS).add(zItemTag.DUST_AMETHYST).output(zItems.NEPTUNIUM, 2).unlockedBy().save(c);
        UrnRitualBuilder.of().add(zItemTag.NEPTUNIUM).add(zItems.INFERNAL_EMBER).add((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).output(zItems.AMERICIUM, 2).unlockedBy().save(c);
        UrnRitualBuilder.of().add(zItemTag.AMERICIUM).add(zItemTag.DUST_COPPER).add(zItemTag.DUST_GOLD).add(zItemTag.DUST_EMERALD).output(zItems.BERKELIUM, 2).unlockedBy().save(c);
        UrnRitualBuilder.of().add(zItemTag.BERKELIUM).add(zItemTag.DUST_ANCIENT_DEBRIS).add(zItems.ENERGIZED_REDSTONE).output(zItems.CURIUM, 2).unlockedBy().save(c);
        ReactorCellBuilder.of().input(zItemTag.URANIUM).output(zItems.WASTE_FRAGMENT, 3).duration(10000).energy(20).heat(50.0).group("synergy").unlockedBy().save(c, "_from_uranium");
        ReactorCellBuilder.of().input(zItemTag.THORIUM).output(zItems.WASTE_FRAGMENT, 6).duration(25000).energy(80).heat(90.0).group("synergy").unlockedBy().save(c, "_from_thorium");
        ReactorCellBuilder.of().input(zItemTag.PLUTONIUM).output(zItems.WASTE_FRAGMENT, 9).duration(50000).energy(160).heat(180.0).group("synergy").unlockedBy().save(c, "_from_plutonium");
        ReactorCellBuilder.of().input(zItemTag.NEPTUNIUM).output(zItems.WASTE_FRAGMENT, 12).duration(75000).energy(300).heat(350.0).group("synergy").unlockedBy().save(c, "_from_neptunium");
        ReactorCellBuilder.of().input(zItemTag.AMERICIUM).output(zItems.WASTE_FRAGMENT, 15).duration(150000).energy(750).heat(1040.0).group("synergy").unlockedBy().save(c, "_from_americium");
        ReactorCellBuilder.of().input(zItemTag.BERKELIUM).output(zItems.WASTE_FRAGMENT, 18).duration(300000).energy(1500).heat(1700.0).group("synergy").unlockedBy().save(c, "_from_berkelium");
        ReactorCellBuilder.of().input(zItemTag.CALIFORNIUM).output(zItems.WASTE_FRAGMENT, 21).duration(750000).energy(2700).heat(3500.0).group("synergy").unlockedBy().save(c, "_from_californium");
        ReactorCellBuilder.of().input(zItemTag.CURIUM).output(zItems.WASTE_FRAGMENT, 24).duration(1250000).energy(3500).heat(7500.0).group("synergy").unlockedBy().save(c, "_from_curium");
    }

    protected void mixtures(RecipeOutput c) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.BONE_MEAL_MIXTURE.get()), (int)2).requires(Tags.Items.SLIME_BALLS).requires((ItemLike)Items.BONE_MEAL).requires(Tags.Items.DUSTS_REDSTONE).requires((ItemLike)Items.BLAZE_POWDER).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)Items.BLAZE_POWDER)).group(zStatic.tips.MIXTURE_TIP).save(c);
        UrnRitualBuilder.of().add((TagKey<Item>)Tags.Items.SLIME_BALLS).add((Item)zItems.ENERGIZED_REDSTONE.get()).add((Item)zItems.LAPIS_DUST.get()).add(Items.PRISMARINE_CRYSTALS).output((Item)zItems.GLOWSTONE_MIXTURE.get(), 5).unlockedBy().save(c);
        UrnRitualBuilder.of().add(zItemTag.GEMS_SILICON).add((Item)zItems.QUARTZ_DUST.get()).add((Item)zItems.AMETHYST_DUST.get()).add(Items.HONEYCOMB).output((Item)zItems.AMETHYST_MIXTURE.get(), 9).unlockedBy().save(c);
    }

    protected void chests(RecipeOutput c) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zBlocks.WOODEN_TINY_CHEST.get()), (int)4).requires((ItemLike)Items.CHEST).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)Items.CHEST)).save(c);
        UrnRitualBuilder.of().add((ItemLike)zBlocks.WOODEN_TINY_CHEST.get()).add((TagKey<Item>)Tags.Items.NUGGETS_GOLD).output((ItemLike)zBlocks.ORNATE_TINY_CHEST.get()).unlockedBy().save(c);
        UrnRitualBuilder.of().add((ItemLike)zBlocks.WOODEN_TINY_CHEST.get()).add(zItems.STONE_PEBBLE).output((ItemLike)zBlocks.STONE_TINY_CHEST.get()).unlockedBy().save(c);
    }

    protected void tools(RecipeOutput c) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.WOODEN_CROOK.get())).pattern("SS").pattern(" S").pattern(" S").define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)Items.STICK)).group(zStatic.Items.wooden_crook).save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.WOODEN_CROOK.get())).pattern("SS").pattern("S ").pattern("S ").define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)Items.STICK)).group(zStatic.Items.wooden_crook).save(c, x.rl(((Croock)((Object)zItems.WOODEN_CROOK.get())).getDescriptionId().replace("item.synergy.", "") + "_alt"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.SMASHER.get())).pattern("NI ").pattern(" I ").pattern(" IN").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)Items.IRON_INGOT)).group(zStatic.Items.smasher).save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.SMASHER.get())).pattern(" IN").pattern(" I ").pattern("NI ").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)Items.IRON_INGOT)).group(zStatic.Items.smasher).save(c, x.rl(((Item)zItems.SMASHER.get()).getDescriptionId().replace("item.synergy.", "") + "_alt"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.SOLDERING_GUN.get())).pattern("  I").pattern(" G ").pattern("S  ").define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('G'), zItemTag.FOIL_GOLD).define(Character.valueOf('I'), (ItemLike)Items.IRON_NUGGET).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zItems.GOLD_FOIL.get()))).group(zStatic.Items.soldering_gun).save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.PIPE_REFARCTORIZER.get())).pattern(" I").pattern("S ").define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('I'), (ItemLike)Items.IRON_NUGGET).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)Items.IRON_INGOT)).group(zStatic.Items.refactorizer).save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zItems.CONFIGURATOR.get())).pattern("N N").pattern("IEI").pattern("RIR").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('E'), (ItemLike)Items.EMERALD).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)Items.REDSTONE)).group(zStatic.Items.configurator).save(c);
    }

    protected void foil(RecipeOutput c, TagKey<Item> input, Item output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern(" IS").pattern(" I ").pattern("SI ").define(Character.valueOf('I'), input).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)Items.STICK)).group("synergy").save(c);
    }

    protected void coil(RecipeOutput c, TagKey<Item> input, Item output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).pattern("I").pattern("I").define(Character.valueOf('I'), input).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)Items.STICK)).group("synergy").save(c);
    }

    protected void moderators(RecipeOutput c) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zBlocks.SIMPLE_MODERATOR.get())).pattern(" S ").pattern("SFS").pattern(" S ").define(Character.valueOf('F'), Tags.Items.STORAGE_BLOCKS_COAL).define(Character.valueOf('S'), zItemTag.PLATE_AQUAMARINE).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zBlocks.ADVANCED_MACHINE_FRAME.get()))).group("synergy").save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zBlocks.ADVANCED_MODERATOR.get())).pattern("CSC").pattern("SFS").pattern("CSC").define(Character.valueOf('F'), (ItemLike)zBlocks.SIMPLE_MODERATOR.get()).define(Character.valueOf('S'), zItemTag.PLATE_STEEL).define(Character.valueOf('C'), zItemTag.NUGGET_ADVANCEDALLOY).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zBlocks.SIMPLE_MODERATOR.get()))).group("synergy").save(c);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)zBlocks.ELITE_MODERATOR.get())).pattern("SPS").pattern("CFC").pattern("SPS").define(Character.valueOf('F'), (ItemLike)zBlocks.ADVANCED_MODERATOR.get()).define(Character.valueOf('P'), (ItemLike)zItems.NETHER_CIRCUIT.get()).define(Character.valueOf('C'), (ItemLike)zItems.CARBON_PLATE.get()).define(Character.valueOf('S'), zItemTag.PLATE_ADVANCED_ALLOY).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)((ItemLike)zBlocks.ADVANCED_MODERATOR.get()))).group("synergy").save(c);
    }

    protected void droplets(RecipeOutput c) {
        List<DeferredHolder<Item, Item>> droplets = List.of(zItems.SAP, zItems.OIL, zItems.GLUE);
        List<zFluid> fluids = List.of(zFluids.SAP, zFluids.OIL, zFluids.GLUE);
        droplets.forEach(d -> {
            BucketItem bucket = (BucketItem)((zFluid)fluids.get(droplets.indexOf(d))).getItemBucket().get();
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)d.get()), (int)3).requires((ItemLike)bucket).unlockedBy("synergy", ExtraRecipeProvider.has((ItemLike)bucket)).save(c);
        });
    }

    protected static void packUnpack(RecipeOutput c, ItemLike unpacked, ItemLike packed, boolean isSmall) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)unpacked, (int)(isSmall ? 4 : 9)).requires(packed).group("synergy").unlockedBy(ExtraRecipeProvider.getHasName((ItemLike)packed), ExtraRecipeProvider.has((ItemLike)packed)).save(c, "synergy:" + x.path((Item)unpacked) + "_unpack" + (isSmall ? "_4" : "_9"));
        ShapedRecipeBuilder temp = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)packed).define(Character.valueOf('#'), unpacked).pattern("##" + (!isSmall ? "#" : "")).pattern("##" + (!isSmall ? "#" : ""));
        if (!isSmall) {
            temp = temp.pattern("###");
        }
        temp.group("synergy").unlockedBy(ExtraRecipeProvider.getHasName((ItemLike)unpacked), ExtraRecipeProvider.has((ItemLike)unpacked)).save(c, "synergy:" + x.path((Item)packed) + "_pack" + (isSmall ? "_x4" : "_x9"));
    }
}

