/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.datagen;

import com.devdyna.synergy.api.node.nodeType;
import com.devdyna.synergy.api.pipe.pipeType;
import com.devdyna.synergy.api.reactor.ControllerProperties;
import com.devdyna.synergy.api.zFluid;
import com.devdyna.synergy.init.builder.DryableBricks;
import com.devdyna.synergy.init.builder.reactor.controller.ReactorControllerBlock;
import com.devdyna.synergy.init.types.zBlocks;
import com.devdyna.synergy.utils.DataGenUtil;
import com.devdyna.synergy.utils.x;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class ExtraBlockStateProvider
extends BlockStateProvider {
    public ExtraBlockStateProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        super(output, modid, exFileHelper);
    }

    protected void brick(DeferredHolder<Block, Block> b, ResourceLocation working, ResourceLocation dried) {
        this.getVariantBuilder((Block)b.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(b.getRegisteredName() + ((Boolean)state.getValue((Property)DryableBricks.DRIED) != false ? "_dried" : "_not_dried"), this.modLoc("block/base_brick"))).texture("texture", (Boolean)state.getValue((Property)DryableBricks.DRIED) != false ? dried : working)).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build());
    }

    protected void tinyChestAll(DeferredHolder<Block, Block> b, String texture) {
        this.tinyChest(b, texture, texture, texture, texture, texture, texture, texture);
    }

    protected void tinyChest(DeferredHolder<Block, Block> b, String particles, String north, String south, String east, String west, String up, String down) {
        this.horizontalBlock((Block)b.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(b.getRegisteredName(), this.modLoc("block/tiny_block/chest"))).texture("particle", particles)).texture("north", north)).texture("south", south)).texture("east", east)).texture("west", west)).texture("up", up)).texture("down", down));
    }

    protected void block(DeferredHolder<Block, Block> b, String rl) {
        this.simpleBlock((Block)b.get(), (ModelFile)this.models().withExistingParent(b.getRegisteredName(), this.modLoc(rl)));
    }

    protected void simpleBlockDecorative(DeferredHolder<Block, Block> b) {
        this.simpleFullBlock(b, "decorative/");
    }

    protected void simpleFullBlock(DeferredHolder<Block, Block> b, String prefix) {
        this.simpleFlexibleBlock(b, b.getRegisteredName().replace("synergy:", prefix));
    }

    protected void simpleFlexibleBlock(DeferredHolder<Block, Block> b, String loc) {
        this.simpleBlock((Block)b.get(), (ModelFile)this.models().cubeAll(b.getRegisteredName(), this.modLoc("block/" + loc)));
    }

    protected void CoolerBlock(DeferredHolder<Block, Block> b, ResourceLocation below) {
        this.simpleBlock((Block)b.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(b.getRegisteredName(), this.modLoc("block/double_layer"))).texture("top", "block/reactor/cooler/casing")).texture("below", below));
    }

    protected void simpleBiState(DeferredHolder<Block, Block> b, String location) {
        this.getVariantBuilder((Block)b.get()).forAllStates(state -> {
            String front = (Boolean)state.getValue((Property)BlockStateProperties.ENABLED) != false ? "on" : "off";
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(b.getRegisteredName() + "_" + front, this.modLoc("block/" + location + front))).build();
        });
    }

    protected void moderatorBlock(DeferredHolder<Block, Block> b, ResourceLocation below) {
        this.getVariantBuilder((Block)b.get()).forAllStates(state -> {
            String front = (Boolean)state.getValue((Property)BlockStateProperties.ENABLED) != false ? "on" : "off";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(b.getRegisteredName() + "_" + front, this.modLoc("block/double_layer"))).texture("top", "block/reactor/moderator/base_" + front)).texture("below", below)).build();
        });
    }

    protected void reactorController(DeferredHolder<Block, Block> b) {
        this.getVariantBuilder((Block)b.get()).forAllStates(state -> {
            String front = switch ((ControllerProperties)((Object)((Object)state.getValue(ReactorControllerBlock.STATUS)))) {
                case ControllerProperties.WAITING -> "front_off";
                case ControllerProperties.NOFUEL -> "front_nocell";
                case ControllerProperties.OVERHEATED -> "front_overheated";
                case ControllerProperties.PRODUCTION -> "front_on";
                default -> "";
            };
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().orientableWithBottom(b.getRegisteredName() + front, this.modLoc("block/reactor/controller/side"), this.modLoc("block/reactor/controller/" + front), this.modLoc("block/reactor/controller/bottom"), this.modLoc("block/reactor/controller/top"))).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 0) % 360).build();
        });
    }

    protected void pipe(Block b) {
        MultiPartBlockStateBuilder model = this.getMultipartBuilder(b);
        ModelFile.ExistingModelFile core2 = this.models().getExistingFile(this.modLoc("block/pipe/basic/core"));
        ModelFile.ExistingModelFile pipe = this.models().getExistingFile(this.modLoc("block/pipe/basic/pipe"));
        pipeType.getPipeMultiPart(b, model, (ModelFile)core2, (ModelFile)pipe);
    }

    protected void node(Block b, String color) {
        MultiPartBlockStateBuilder model = this.getMultipartBuilder(b);
        ModelFile.ExistingModelFile core2 = this.models().getExistingFile(this.modLoc("block/pipe/basic/core"));
        ModelFile.ExistingModelFile pipe = this.models().getExistingFile(this.modLoc("block/pipe/basic/pipe"));
        BlockModelBuilder node = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(b.getDescriptionId().replace("block.synergy.", ""), this.modLoc("block/node/_template/block"))).texture("pipe", "synergy:block/pipe/black")).texture("node", "synergy:block/node/" + color)).texture("back", "synergy:block/node/back");
        nodeType.getNodeMultiPart(b, model, (ModelFile)core2, (ModelFile)pipe, (ModelFile)node);
    }

    protected void crop(Block b, int max, boolean isCrop, IntegerProperty property) {
        String name = b.getDescriptionId().replace("block.synergy.", "");
        VariantBlockStateBuilder model = (VariantBlockStateBuilder)this.getVariantBuilder(b).partialState().with((Property)property, (Comparable)Integer.valueOf(0)).modelForState().modelFile((ModelFile)DataGenUtil.crossORcrop(this, isCrop, "crops/" + name + "/0", this.modLoc("block/crops/" + name + "/0"))).addModel();
        for (int index = 1; index <= max; ++index) {
            model.partialState().with((Property)property, (Comparable)Integer.valueOf(index)).modelForState().modelFile((ModelFile)DataGenUtil.crossORcrop(this, isCrop, "crops/" + name + "/" + index, this.modLoc("block/crops/" + name + "/" + index))).addModel();
        }
    }

    protected void growPlantWithVariants(Block b, int max, boolean isCrop, IntegerProperty property) {
        String name = b.getDescriptionId().replace("block.synergy.", "");
        VariantBlockStateBuilder model = this.getVariantBuilder(b);
        model.partialState().with((Property)property, (Comparable)Integer.valueOf(0)).addModels(ConfiguredModel.builder().modelFile((ModelFile)DataGenUtil.crossORcrop(this, isCrop, "crops/" + name + "/0/0", this.modLoc("block/crops/" + name + "/0/0"))).nextModel().modelFile((ModelFile)DataGenUtil.crossORcrop(this, isCrop, "crops/" + name + "/1/0", this.modLoc("block/crops/" + name + "/1/0"))).build());
        for (int index = 1; index <= max; ++index) {
            model.partialState().with((Property)property, (Comparable)Integer.valueOf(index)).addModels(ConfiguredModel.builder().modelFile((ModelFile)DataGenUtil.crossORcrop(this, isCrop, "crops/" + name + "/0/" + index, this.modLoc("block/crops/" + name + "/0/" + index))).nextModel().modelFile((ModelFile)DataGenUtil.crossORcrop(this, isCrop, "crops/" + name + "/1/" + index, this.modLoc("block/crops/" + name + "/1/" + index))).build());
        }
    }

    protected void rotableBlock(Block b) {
        this.rotableBlock(b, x.rl(b));
    }

    protected void rotableBlock(Block b, ResourceLocation path) {
        VariantBlockStateBuilder model = this.getVariantBuilder(b);
        model.partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(path)).nextModel().modelFile((ModelFile)this.models().getExistingFile(path)).rotationY(90).nextModel().modelFile((ModelFile)this.models().getExistingFile(path)).rotationY(180).nextModel().modelFile((ModelFile)this.models().getExistingFile(path)).rotationY(270).build());
    }

    protected void crossORcropStatic(Block b, boolean isCrop, String texturePath) {
        VariantBlockStateBuilder model = this.getVariantBuilder(b);
        model.partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)DataGenUtil.crossORcrop(this, isCrop, x.path(b), this.modLoc(texturePath))).build());
    }

    protected void fluid(zFluid fluid) {
        this.getVariantBuilder((Block)fluid.getBlock().get()).partialState().modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().getBuilder("block/" + fluid.getId())).texture("particle", fluid.getStill())).addModel();
    }

    protected void decorativeBlocks() {
        zBlocks.zBlockSlab.getEntries().forEach(b -> this.slabBlock((SlabBlock)b.get(), this.modLoc("block/" + x.path((Block)b.get()).replace("synergy:block/", "").replace("_slab", "")), this.modLoc("block/decorative/" + x.path((Block)b.get()).replace("synergy:block/", "").replace("_slab", ""))));
        zBlocks.zBlockStair.getEntries().forEach(b -> this.stairsBlock((StairBlock)b.get(), this.modLoc("block/decorative/" + x.path((Block)b.get()).replace("synergy:block/", "").replace("_stair", ""))));
    }
}

