/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.client;

import com.devdyna.synergy.init.types.zComponents;
import com.devdyna.synergy.init.types.zItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface TypeRenders<T> {
    default public int getPlayerDistance() {
        return 16;
    }

    default public void renderDebugBox(BlockEntity be, BlockPos start, BlockPos end, @Nullable Direction dir, PoseStack stack, MultiBufferSource bufferIn) {
        Player player = be.getLevel().getNearestPlayer((double)be.getBlockPos().getX(), (double)be.getBlockPos().getY(), (double)be.getBlockPos().getZ(), (double)this.getPlayerDistance(), false);
        VertexConsumer vertexconsumer = bufferIn.getBuffer(RenderType.lines());
        if (dir != null) {
            switch (dir) {
                case NORTH: {
                    start = start.relative(Direction.SOUTH, 1);
                    end = end.relative(Direction.EAST, 1);
                    break;
                }
                case SOUTH: {
                    end = end.relative(Direction.SOUTH, 1).relative(Direction.EAST, 1);
                    break;
                }
                case EAST: {
                    end = end.relative(Direction.SOUTH, 1);
                    end = end.relative(Direction.EAST, 1);
                    break;
                }
                case WEST: {
                    start = start.relative(Direction.EAST, 1);
                    end = end.relative(Direction.SOUTH, 1);
                    break;
                }
            }
        }
        if (this.checkTool(player, be.getBlockPos())) {
            stack.pushPose();
            LevelRenderer.renderLineBox((PoseStack)stack, (VertexConsumer)vertexconsumer, (double)start.getX(), (double)start.getY(), (double)start.getZ(), (double)end.getX(), (double)(end.getY() + 1), (double)end.getZ(), (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
            stack.popPose();
        }
    }

    default public boolean checkTool(Player player, BlockPos pos) {
        ItemStack item;
        if (player == null) {
            return false;
        }
        ItemStack mainH = player.getMainHandItem();
        ItemStack offH = player.getOffhandItem();
        if (mainH != null && mainH.is(zItems.CONFIGURATOR)) {
            item = mainH;
        } else if (offH != null && offH.is(zItems.CONFIGURATOR)) {
            item = offH;
        } else {
            return false;
        }
        if (!item.is(zItems.CONFIGURATOR)) {
            return false;
        }
        if (item.get(zComponents.GLOBAL_POS) == null) {
            return false;
        }
        if (((GlobalPos)item.get(zComponents.GLOBAL_POS)).dimension() != player.level().dimension()) {
            return false;
        }
        return ((GlobalPos)item.get(zComponents.GLOBAL_POS)).pos().getX() == pos.getX() && ((GlobalPos)item.get(zComponents.GLOBAL_POS)).pos().getY() == pos.getY() && ((GlobalPos)item.get(zComponents.GLOBAL_POS)).pos().getZ() == pos.getZ();
    }
}

